<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net
 */
/**
 * @file URN.php
 * @brief URN
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: URN.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * URN
 */
require_once("ficus/net/OpaqueURI.php");
require_once("ficus/exception/URISyntaxException.php");
require_once("ficus/exception/IllegalArgumentException.php");
/**
 * @class Ficus_URN
 */
 class Ficus_URN extends Ficus_OpaqueURI {

    /**
     * Get default scheme.
     *
     * @return string scheme name.
     */
    final public function getDefaultScheme() {
        return 'urn';
    }

    /**
     * Parse URN.
     *
     * @throw Ficus_URISyntaxException invalid NID in URN.
     */
    protected function parse(){
        parent::parse();
        $pathes = preg_split('/:/', $this->getPath());
        $this->nid = $pathes[0];
        if (preg_match('/[a-zA-Z0-9][a-zA-Z0-9\\-]{1,31}/', $this->nid) === 0) {
            throw new Ficus_URISyntaxException("Illegal URN NID: {$this->nid}");
        }
        if (strcasecmp($this->getDefaultNID(), $this->nid) !== 0) {
            throw new Ficus_URISyntaxException("Illegal URN NID: {$this->nid} is not {$this->getDefaultNID()}.");
        }
        $this->nss = array_slice($pathes, 1);
    }

    /**
     * Get default NID.
     *
     * @return string NID.
     */
    public function getDefaultNID() {
        return strtolower($this->nid);
    }

    /**
     * Get NID.
     *
     * @return string NID.
     */
    final public function getNID() {
        return $this->nid;
    }

    /**
     * Get NSS.
     *
     * @param $num int number of NSS.
     * @return mixed NSS array or NSS[$num].
     * @throw Ficus_IllegalArgumentException illegal number.
     */
    final public function getNSS($num = null){
        if ($num === null) {
            return $this->nss;
        } else if (is_numeric($num)) {
            return isset($this->nss[$num]) ? $this->nss[$num] : null;
        } else {
            throw new Ficus_IllegalArgumentException("getNSS() need numeric argument.");
        }
    }

}
?>
