<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net
 */
/**
 * @file URNFactoryImpl.php
 * @brief URNFactoryImpl
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: URNFactoryImpl.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * URNFactoryImpl
 */
require_once("ficus/net/URIFactoryImpl.php");
require_once("ficus/net/URN.php");
require_once("ficus/net/IsbnURN.php");
require_once("ficus/exception/URISyntaxException.php");
require_once("ficus/exception/IllegalArgumentException.php");
/**
 * @class Ficus_URNFactoryImpl
 */
class Ficus_URNFactoryImpl extends Ficus_URIFactoryImpl {

    /**
     * Get suffix of class name.
     *
     * @return string suffix.
     */
    public function getSuffix() {
        return 'URN';
    }

    /**
     * Default URI .
     *
     * @param $uri string URI.
     * @return Ficus_URI URI.
     */
    public function defaultInstance($uri) {
        return new Ficus_URN($uri);
    }

    /**
     * Factory method.
     *
     * @param $uri string URI.
     * @return Ficus_URI URI.
     */
    public function createInstance($scheme, $uri) {
        try {
            $split = preg_split('/:/', $uri);
            $componentKey = 'urn.nid.' . strtolower($split[1]);
            $component = Ficus_URIFactoryComponentFactory::getBuilderComponent($scheme, $componentKey);
            if (!($component instanceof Ficus_URNFactoryImpl)) {
                return $component->createInstance($scheme, $uri);
            }
        } catch (S2Container_ComponentNotFoundRuntimeException $e) {
            // do nothing.
            //var_dump($e->getMessage());
        } catch (Ficus_MethodNotFoundException $e) {
            var_dump($e->getTraceAsString());
        } catch (Exception $e) {
            var_dump(get_class($e));
            var_dump($e->getMessage());
        }

        $split = preg_split('/:/', $uri);
        $nid = $split[1];
        return Ficus_URIFactoryImpl::createInstance($nid, $uri);
    }

}
?>
