<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net.mail
 */
/**
 * @file MailAttachment.php
 * @brief MailAttachment for php
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: MailAttachment.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * MailAttachment for php
 */

require_once("ficus/beans/Bean.php");

/**
 * @class Ficus_MailAttachment
 */
class Ficus_MailAttachment extends Ficus_Bean{
    const ENCODING_ISO_2022_JP = "iso-2022-jp";
    const ENCODING_UTF8 = "utf-8";

    /**
     * filename
     */
    protected $filename = "";

    /**
     * body
     */
    protected $body = "";

    /**
     * charset
     */
    protected $charset = self::ENCODING_ISO_2022_JP;

    /**
     * mime
     */
    protected $mime = "";

    /**
     * part
     */
    protected $part = array();

    /**
     * set part
     */
    public function decode($part){
        $this->part = $part;
        $this->filename = $part->d_parameters["filename"];
        $this->body = $part->body;
        $this->mime = $part->ctype_primary . "/" . $part->ctype_secondary;
    }
}
?>
