<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net.rmi
 */
/**
 * @file PukiWikiRMI.php
 * @brief access to pukiwiki
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PukiWikiRMI.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * access to pukiwiki
 */

require_once("ficus/net/rmi/AbstractRemoteMethodInvocation.php");

/**
 * @class Ficus_PukiWikiRMI
 */
class Ficus_PukiWikiRMI extends Ficus_AbstractRemoteMethodInvocation
{
    const PUKIWIKI_PAGENAME = "page";
    const PUKIWIKI_WRITE = "write";
    const PUKIWIKI_CMD = "cmd";
    const PUKIWIKI_CONTENTS = "msg";
    const PUKIWIKI_DIGEST = "digest";

    const CMD_EDIT = "edit";

    /**
     * create page
     * @param $name string name of page
     * @param $contents string contents of page
     * @param $encoding string encoding if setted, convert response
     */
    public function createPage($name, $contents, $encoding = null){
        if(empty($name)){
            throw new Ficus_IllegalArgumentException("name must not be empty");
        }else if(empty($contents)){
            throw new Ficus_IllegalArgumentException("contents mut not be empty");
        }

        $request =
            array(self::PUKIWIKI_PAGENAME => $this->getEncoded($name),
                  self::PUKIWIKI_CMD      => self::CMD_EDIT,
                  self::PUKIWIKI_WRITE    => true,
                  self::PUKIWIKI_CONTENTS => $this->getEncoded($contents),
                  self::PUKIWIKI_DIGEST   => md5(""));

        $response = $this->invoke($request);
        if(is_null($encoding)){
            return $response;
        }else{
            return mb_convert_encoding($response, $encoding, $this->encoding);
        }
    }

    /**
     * get file name from page name
     * @param $name string name of page name
     * @return string page name
     */
    public function getFileName($pagename){
    }
}
?>
