<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold
 */
/**
 * @file AbstractScaffoldForeperson.php
 * @brief index page of administrator site
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: AbstractScaffoldForeperson.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once("ficus/config/Registry.php");

/**
 * @class Ficus_AbstractScaffoldForeperson
 */
abstract class Ficus_AbstractScaffoldForeperson
implements Ficus_ScaffoldForeperson, Ficus_ScaffoldConstants{
    protected $mediator = null;

    /**
     * constructor
     */
    public function __construct($mediator){
        $this->mediator = $mediator;
    }

    /**
     * invoke
     */
    protected function invoke(){
        if($this->mediator->request()->has(self::KEY_DO)){
            $key = $this->mediator->request()->extractAsString(self::KEY_DO);
        }else{
            $key = self::DO_DEFAULT;
        }
        $method = self::METHOD_PREFIX . ucfirst($key);
        if(method_exists($this, $method) == false){
            throw new Ficus_IllegalArgumentException("method $method is not implemented");
        }
        return $this->{$method}();
    }

    /**
     * organaize scaffold
     * @return string organized result
     */
    public function organize(){
        return $this->invoke();
    }
}    
?>
