<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold
 */
/**
 * @file EditScaffold.php
 * @brief table manager page
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: EditScaffoldForeperson.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once("ficus/pages/AbstractPage.php");
require_once("ficus/config/Registry.php");
require_once("ficus/db/s2dao/models/serializer/S2DaoS2DaoArrayEntityDeserializer.php");
require_once("common/AbstractPage.php");

/**
 * @class Ficus_EditScaffold
 */
class Ficus_EditScaffold extends Ficus_AbstractScaffold    
    /**
     * edit
     * @param $args array of arguments
     */ 
    public function doEdit($args){
        $entity = $this->getSingleEntity($this->extractArgument($args, "id"));
        $container = $this->getContainer($entity);
        
        $organizer = $this->getEditOrganizer();
        $organizer->setItemTemplate("row");
        $organizer->setEntityTemplate("table");

        $container->addOrganizers($organizer);
        $this->assignReference("container", $container);
        if(($transition = $this->getNextTransition()) !== false){
            $this->assign("transition", $transition);
            $this->setNextAction("editChildren");
        }else{
            $this->setNextAction("editConfirm");
        }
        return self::MODE_TEMPLATE;
    }

    /**
     * edit children
     * @param $args array of arguments
     */
    public function doEditChildren($args){
        $current = $args["transition"];
        $entity = $this->deserializeEntity($args);
        $container = $this->getContainer($entity);
        
        $organizer = $this->getEditOrganizer();
        $organizer->setItemTemplate("row");
        $organizer->setEntityTemplate("table");
        $organizer->mediator()->setTransition($current);
        $organizer->mediator()->setNoChildren(false);

        $container->addOrganizers($organizer);
        if(($transition = $this->getNextTransition($current)) !== false){
            $this->assign("transition", $transition);
            $this->setNextAction("editChildren");
        }else{
            $this->setNextAction("editConfirm");
        }
        $this->assignReference("container", $container);
        return "common/TableManagerEdit.tpl";
    }

    /**
     * edit confirm
     * @param $args array of arguments
     */
    public function doEditConfirm($args){
        $entity = $this->deserializeEntity($args);
        $container = $this->getContainer($entity);
        
        $organizer = $this->getViewOrganizer();
        $organizer->setItemTemplate("row");
        $organizer->setEntityTemplate("table");

        $container->addOrganizers($organizer);
        $container->addOrganizers($this->getHiddenOrganizer());
        $this->assignReference("container", $container);
        $this->setNextAction("common.editSubmit");

        return "common/TableManagerConfirm.tpl";
    }

    /**
     * edit submit
     * @param $args array of arguments
     */
    public function doEditSubmit($args){
        $entity = $this->deserializeEntity($args);
        $container = $this->getContainer($entity);

        $organizer = $this->getViewOrganizer();
        $organizer->setItemTemplate("row");
        $organizer->setEntityTemplate("table");

        $container->addOrganizers($organizer);
        $this->assignReference("container", $container);

        $entity->update();
        
        return self::MODE_TEMPLATE;
    }
}    
?>
