<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold
 */
/**
 * @file ScaffoldConstants.php
 * @brief scaffold interface
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ScaffoldConstants.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once("ficus/config/Registry.php");

/**
 * @interface ScaffoldConstants
 */
interface Ficus_ScaffoldConstants{
    const REGISTRY_SETTINGS = "scaffoldSettings";
    const REGISTRY_TABLESETTINGS = "tableSettings";
    const REGISTRY_SMARTYCACHE = "smarty.cache";
    const REGISTRY_SCAFFOLD_TEMPLATES = "scaffold.templates";

    const REGISTRY_NOLABELS = "nolabels";
    const REGISTRY_EXCLUDES = "excludes";
    const REGISTRY_NOCHILDREN = "nochildren";
    const REGISTRY_DEFAULTS = "defaults";
    const REGISTRY_TRANSITION = "transition";

    const METHOD_PREFIX = "do";

    const ACTION_PREFIX = "scaffold";
    const ACTION_NEW = "new";
    const ACTION_LIST = "list";
    const ACTION_VIEW = "view";
    const ACTION_EDIT = "edit";
    const ACTION_DELETE = "delete";

    const DO_DEFAULT = "default";
    const DO_CHILDREN = "children";
    const DO_CONFIRM = "confirm";
    const DO_SUBMIT = "submit";

    const SCAFFOLD_TEMPLATES = "scaffold";
    const TEMPLATE_HEADER = "scaffoldHeader";
    const TEMPLATE_FOOTER = "scaffoldFooter";

    const KEY_SCAFFOLD = "scaffold";
    const KEY_PAGE     = "scaffold_nextPage";
    const KEY_METHOD   = "scaffold_method";
    const KEY_ACTION   = "scaffold_nextAction";
    const KEY_TARGET   = "scaffold_target";
    const KEY_DO       = "scaffold_do";
    const KEY_MESSAGE  = "scaffold_message";
    const KEY_TRANSITION = "scaffold_transition";
    const KEY_SUBMIT_TITLE = "scaffold_submitTitle";
    const KEY_FOREPERSON = "scaffold_foreperson";

    const METHOD_POST = "post";
    const METHOD_GET  = "get";

    const SMARTY_SCAFFOLD = "scaffold";
}
?>
