<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold
 */
/**
 * @file Form bean.php
 * @brief Form bean.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ScaffoldFormBean.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */

require_once("ficus/db/s2dao/models/S2DaoModelConstants.php");
require_once("ficus/db/s2dao/models/S2DaoDataAccessObject.php");

/**
 * @class Ficus_ScaffoldFormBean
 */
class Ficus_ScaffoldFormBean extends Ficus_Bean
implements Ficus_ScaffoldConstants{
    /**
     * $page string form action
     */
    protected $page = null;
    
    /**
     * $method string form method post or get
     */
    protected $method = self::METHOD_POST;
    
    /**
     * $action string page's action, not a scaffold action
     */
    protected $action = null;

    /**
     * $target string target table name
     */
    protected $target = null;

    /**
     * $do string scaffold's action.
     */
    protected $do = null;

    /**
     * $submitTitle string submit button value
     */
    protected $submitTitle = self::SUBMIT_TITLE;

    /**
     * $transition string transition
     */
    protected $transition = null;

    /**
     * $foreperson string foreperson
     */
    protected $foreperson = null;

    /**
     * $message string message
     */
    protected $message = null;
}
?>
