<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold.util
 */
/**
 * @file ScaffoldTemplateParser.php
 * @brief ScaffoldTemplateParser.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ScaffoldTemplateParser.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */

require_once("ficus/lang/Assert.php");

/**
 * @class Ficus_ScaffoldTemplateParser
 */
class Ficus_ScaffoldTemplateParser
implements Ficus_S2DaoModelConstants{
    public static function getTemplate($part){
        Ficus_Assert::isInstanceOf($part, "Ficus_ScaffoldPart");
        if($part->value() instanceof Ficus_S2DaoEntity){
            $entityName = $part->value()->getEntityName();
            $settings = Ficus_Registry::search("tableSettings");
            if(isset($settings[$entityName]) &&
               isset($settings[$entityName]["view"])){
                return $settings[$entityName]["view"];
            }
        }
        return false;
    }

    public static function parse($template, $part, $recursive = true){
        Ficus_Assert::isInstanceOf($part, "Ficus_ScaffoldPart");
        preg_match_all('/[{][$](.+?)[}]/', $template, $regs);
        $ret = $template;
        foreach($regs[1] as $property){
            $name = explode(".", $property);
            $value = self::getValue($name, $part, $recursive);
            if(is_null($value) == false){
                $ret = str_replace("{\$$property}", $value, $ret);
            }
        }
        if($ret == $template){
            return "";
        }else{
            return $ret;
        }
    }

    protected static function getValue($name, $part, $recursive){
        $prop = array_shift($name);
        if($part instanceof Ficus_ScaffoldPart){
            $part = $part->getParts($prop);
            if($part instanceof Ficus_ScaffoldPart){
                if($part->type() == self::TYPE_LIST){
                    $key = $part->value()->name();
                    if(is_null($key) == false){
                        return $part->value()->names($part->value()->name());
                    }
                    $key = $part->value()->name();
                    $names = $part->value()->names();
                    $i = 0;
                    foreach($names as $name){
                        if($i == $key){
                            return $name;
                        }
                        $i++;
                    }
                    return null;
                }else if(empty($name) == false){
                    return self::getValue($name, $part, $recursive);
                }
            }
            

            $value = $part->value();
            if($recursive == true&&
               $value instanceof Ficus_S2DaoEntity){
                $template = self::getTemplate($value);
                if(is_null($template) == false){
                    return self::parse($template, $value, $recursive);
                }
            }
            return $value;
        }
        return null;
    }
}
?>