<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.parameters
 */
/**
 * @file ValidatableComplexParameter.php
 * @brief ValidatableComplexParameter for php
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: ValidatableComplexParameter.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * ComplexParameter with Validator.
 */

require_once("ficus/validators/Validatable.php");
require_once("ficus/parameters/ComplexParameter.php");
require_once("ficus/parameters/visitors/Visitor.php");
require_once("ficus/parameters/visitors/Acceptor.php");
require_once("ficus/exception/IllegalTypeException.php");

/**
* @class Ficus_ValidatableComplexParameter
 */
class Ficus_ValidatableComplexParameter extends Ficus_ComplexParameter
                                    implements Ficus_Validatable, Ficus_Acceptor
{
	/**
	 * @var $validator array array of Ficus_Validator for validate parameter
	 */
	private $validator = array();

	/**
	 * construct validiatable Parameter.
	 * @param $name string name
	 * @param $typeName string name of type
	 * @param $value mixed value of this param
	 * @param $validator Ficus_Validator validator for validate parameter
	 */
	function __construct($name, $typeName = "", $value = null,
						 $validator = array()){
		parent::__construct($name, $typeName, $value);
		$this->setValidator($validator);
	}

	/**
	 * validate param
	 * @param $parameter array data
	 */
	public function validate($parameter){
		foreach($this->validator as $validator){
			$validator->validate($parameter);
		}
	}

	/**
	 * accept visitor
	 * @param $visitor Ficus_Visitor visitor
	 */
	public function accept(Ficus_Visitor $visitor){
		$visitor->visit($this);
	}

	/**
	 * set validator
	 * @param $validator Ficus_Validator set validator
     * @throw Ficus_IllegalTypeException illegal validator type.
	 */
	protected function setValidator($validator){
		if($validator == null){
			$this->validator = array();
		}else if(is_array($validator)){
			foreach($validator as $v){
				if($v instanceof Ficus_Validatable){
					array_push($this->validator, $v);
				}else{
					throw new Ficus_IllegalTypeException("validator must be extend Ficus_Validator");
				}
			}
		}else{
			throw new Ficus_IllegalTypeException("validator must be array of Ficus_Validator");
		}
	}
	
	/**
	 * clone method
	 */
	public function __clone(){
		$validator = array();
		$parameters = array();
		foreach($this->validator as $v){
			array_push($validator, clone $v);
		}
		foreach($this->parameters as $parameter){
			array_push($parameters, clone $parameter);
		}
		$this->validator = $validator;
		$this->parameters = $parameters;
	}

	/**
	 * get String form parameter
	 * @return string definition of this parameter
	 */
	public function __toString(){
		$str = "";
		$str .= $this->name() . "|";
		$str .= $this->typeName() . "|";
		$vstr = array();
		foreach($this->validator as $validator){
			array_push($vstr, $validator->__toString());
		}
		$str .= implode(",", $vstr);
		return $str;
	}
}
?>
