<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.parameters.datatypes
 */
/**
 * @file BooleanParameter.php
 * @brief BooleanParameter for php
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: BooleanParameter.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * ValidatableSimpleParameter with normailizer.
 * treat param as boolean
 */

require_once("ficus/exception/ValidationException.php");
require_once("ficus/parameters/ValidatableSimpleParameter.php");
require_once("ficus/lang/Assert.php");
/**
 * @class Ficus_BooleanParameter
 */
class Ficus_BooleanParameter extends Ficus_ValidatableSimpleParameter
{
	const TYPENAME = "boolean";
	
	/**
 	 * construct parameter with name, value, and specific validator.
 	 * @param $name string name of this parameter.
 	 * @param $value string value of this parameter.
 	 * @param $validator array array of Ficus_Validator.
 	 */
 	public function __construct($name, $value = null, $validator = array()){
		parent::__construct($name, self::TYPENAME, $value);
		$this->setValidator($validator);
	}

	/**
	 * check param that associated with simple parameter
	 * must be true or false
	 * @param $parameter array data
	 * @return array validated param
     * @throw Ficus_ValidationException invalidate parameter.
	 */
	public function validate($parameter){
        
        if(array_key_exists("value", $parameter) == false){
            throw new Ficus_ValidationException("parameter value is not specified.");
        }

        $value = $parameter["value"];
        
        if(empty($value) ||
           (is_string($value) && eregi("^(true|1|false|0)$", trim($value)))){
          	
		}else{
			throw new Ficus_ValidationException("parameter {$this->name()} is not boolean value.");
		}
	}
}
?>
