<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.parameters.visitors
 */
/**
 * @file ParameterToDefinitionConverter.php
 * @brief ParameterToDefinitionConverter for php
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ParameterToDefinitionConverter.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * ParameterToDefinitionConverter.
 */

require_once("ficus/lang/Assert.php");
require_once("ficus/parameters/visitors/Acceptor.php");
require_once("ficus/parameters/visitors/Visitor.php");
require_once("ficus/parameters/ParameterBuilder.php");

/**
 * @class Ficus_ParameterToDefinitionConverter
 */
class Ficus_ParameterToDefinitionConverter extends Ficus_Visitor
{
	/**
	 * @var $definition string definition string
	 */
	private $definition = "";

	/**
	 * constructor
	 * @param $param Ficus_Parameter target parameter
	 */
	public function __construct($param){
		Ficus_Assert::typeHinting("Ficus_Parameter", $param);
		$param->accept($this);
	}

	/**
	 * visit parameters and validate
	 * @param $parameter Ficus_Acceptor validatables
	 */
	public function visit($parameter){
		static $depth = 0;
		Ficus_Assert::isInstanceOf($parameter, "Ficus_Acceptor");
		if($parameter instanceof Ficus_Parameter){
			//if type is null, the parameter is name of parameter
			if($parameter->typeName() === ""){
				$this->definition .= $parameter->name() . "\n";
			}else{
				$this->definition .=
					$this->createDefinition($parameter, $depth);
			}

			if($parameter instanceof Ficus_ComplexParameter){
				$depth++;
				//check for child parameters
				$children = $parameter->getParameters();
				foreach($children as $child){
					$child->accept($this);
				}
				$depth--;
			}
		}
	}

	/**
	 * get converted definition
	 * @return string definition
	 */
	public function getConvertedDefinition(){
		return $this->definition;
	}

	/**
	 * create definition from parameter
	 * @param $param Ficus_Parameter target parameter
	 * @param $depth integer multiplier
	 * @return string definition of parameter
	 */
	private function createDefinition($param, $depth){
		$level = str_repeat(Ficus_ParameterBuilder::T_LEVEL, $depth);
		return $level . $param->__toString() . "\n";
	}
}
?>
