/*
 * The Ebisu Project Public License, Version 1.1
 *
 * Copyright (c) 2003 Ebisu Project.  All rights reserved.
 *
 * This license is based on the Apache Software License 1.1
 *                           (http://xml.apache.org/LICENSE) 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        Ebisu Project (http://dacha.tv/ebisu/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Ebisu Project" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written 
 *    permission, please contact dacha@anet.ne.jp.
 *
 * 5. Products derived from this software may not be called "Ebisu",
 *    nor may "Ebisu" appear in their name, without prior written
 *    permission of the Ebisu Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE Ebisu Project OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 */
package tv.dacha.ebisu.ant.tasks;
import org.apache.tools.ant.*;
import org.apache.tools.ant.taskdefs.*;
import java.io.*;
import java.util.*;
import org.apache.tools.ant.types.FileSet;
/**
 * FileIterator.
 * @author Masaki Kato
 * @version 1.0
 */
public class FileIterator extends Task {
	private File path_;
	private boolean file_ = true;
	private boolean dir_  = true;
	private String fileKey_ = "file";
	private String dirKey_  = "dir";
	private ArrayList ants_ = new ArrayList();
	private ArrayList filesets_ = new ArrayList();
	/**
	 * set full path for iteration.<br>
	 * This Attribute is ignored when you use the filesets in FileIterator.<br>
	 * Requied:false<br>
	 * Default:nothing<br>
	 * @param path
	 */
	public void setPath(File path){
		path_ = path;
	}
	/**
	 * Set "false", if you want to scan only directories.<br>
	 * Required:no<br>
	 * Default:"true"<br>
	 * @param true or false
	 */
	public void setFile(boolean file){
		file_ = file;
	}
	/**
	 * Set "false", if you want to scan only files.<br>
	 * Required:no<br>
	 * Default:"true"<br>
	 * @param dir
	 */
	public void setDir(boolean dir){
		dir_ = dir;
	}
	/**
	 * Specify the key for discovered directories.<br>
	 * Required:no<br>
	 * Default:"dir"<br>
	 * @param dirKey
	 */
	public void setDirKey(String dirKey){
		dirKey_ = dirKey;
	}
	/**
	 * Specify the key for discovered files.<br>
	 * Required:no<br>
	 * Default:"file"<br>
	 * @param fileKey
	 */
	public void setFileKey(String fileKey){
		fileKey_ = fileKey;
	}
	
	/**
	 * FileIterator support the type "fileset".
	 * @param set
	 */
    public void addFileset(FileSet set) {
    	filesets_.add(set);
    }
	
	/**
	 * execute FileIterator.
	 */	
    public void execute() throws BuildException {
		if ( filesets_.size() != 0 ){
            for (int i = 0; i < filesets_.size(); i++) {
                FileSet fs = (FileSet) filesets_.get(i);
                DirectoryScanner ds = fs.getDirectoryScanner(project);
                File srcDir = fs.getDir(project);
                String[] srcFiles = ds.getIncludedFiles();
                for (int j = 0 ; j < srcFiles.length ; j++) {
                	File f = new File(srcFiles[j]);
                	String key = null;
                	if ( f.isDirectory() && dir_ ){
                		key = dirKey_;
                	} else if( !f.isDirectory() && file_){
                		key = fileKey_;
                	}
                	if ( key != null ){
	                	getProject().setProperty(key, srcFiles[j]);
						Iterator it = ants_.iterator();
						while ( it.hasNext() ){
							Ant a = (Ant)it.next();
							a.execute();
						}
                	}
                }
            }
		} else {
			if ( path_ != null && path_.exists() ) {
				if ( path_.isDirectory() ) {
					File[] fl = path_.listFiles();
					for ( int i = 0; i < fl.length; i++ ){
	                	getProject().setProperty(dirKey_, fl[i].getAbsolutePath());
						Iterator it = ants_.iterator();
						while ( it.hasNext() ){
							Ant a = (Ant)it.next();
							a.execute();
						}
					}
				} else {
					getProject().setProperty(fileKey_, path_.getAbsolutePath());
					Iterator it = ants_.iterator();
					while ( it.hasNext() ){
						Ant a = (Ant)it.next();
						a.execute();
					}
				}
			}
		}
    }
	
	/**
	 * FileIterator support the task, "ant".
	 * @return Ant Task
	 */    
    public Ant createAnt(){
    	Ant a = new Ant();
    	ants_.add(a);
    	return a;
    }
}
