/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.u6k.filelock;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class FileLockUtil
implements Closeable {
    private Map<String, FileLock> lockMap = new TreeMap<String, FileLock>();
    private Map<String, FileChannel> channelMap = new TreeMap<String, FileChannel>();
    private List<String> lockFileList = new ArrayList<String>();
    private List<String> lockFailFileList = new ArrayList<String>();

    public FileLockUtil(String[] paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i] != null) continue;
            throw new NullPointerException("paths[" + i + "] == null");
        }
        for (String path : paths) {
            this.lock(path);
        }
    }

    private void lock(String path) {
        File file;
        try {
            file = new File(path).getCanonicalFile();
        }
        catch (IOException e) {
            this.lockFailFileList.add(path);
            return;
        }
        if (file.isFile()) {
            try {
                FileChannel fch = new RandomAccessFile(file, "rw").getChannel();
                this.channelMap.put(file.getAbsolutePath(), fch);
                FileLock l = fch.tryLock();
                this.lockMap.put(file.getAbsolutePath(), l);
                this.lockFileList.add(file.getAbsolutePath());
            }
            catch (IOException e) {
                this.lockFailFileList.add(file.getAbsolutePath());
                return;
            }
        } else if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.lock(child.getAbsolutePath());
            }
        }
    }

    public String[] lockFiles() {
        return this.lockFileList.toArray(new String[0]);
    }

    public String[] lockFailFiles() {
        return this.lockFailFileList.toArray(new String[0]);
    }

    public void close() {
        for (FileChannel fch : this.channelMap.values()) {
            try {
                fch.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.channelMap.clear();
        this.lockMap.clear();
        this.lockFileList.clear();
        this.lockFailFileList.clear();
    }
}

