/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.u6k.filelock;

import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import jp.gr.java_conf.u6k.filelock.FileLockUtil;
import jp.gr.java_conf.u6k.filelock.ResourceUtil;

class SwingMain
extends JFrame {
    private static final int COMPONENT_INTERVAL = 10;
    private static final int WIDTH = 400;
    private static final int HEIGHT = 300;
    private JTable lockTable;

    public SwingMain(String[] args) throws IOException {
        final FileLockUtil fileLockUtil = new FileLockUtil(args);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                fileLockUtil.close();
                System.exit(0);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setSize(400, 300);
        this.setTitle(ResourceUtil.get("app.title") + " " + ResourceUtil.get("app.version"));
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/jp/gr/java_conf/u6k/filelock/resources/lock.png")));
        this.setLocationRelativeTo(null);
        Container c = this.getContentPane();
        SpringLayout l = new SpringLayout();
        c.setLayout(l);
        JButton closeButton = new JButton(ResourceUtil.get("message.close"));
        closeButton.setMnemonic(67);
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingMain.this.dispose();
            }
        });
        l.putConstraint("South", (Component)closeButton, -10, "South", (Component)c);
        l.putConstraint("East", (Component)closeButton, -10, "East", (Component)c);
        c.add(closeButton);
        TreeMap<String, Boolean> lockStateMap = new TreeMap<String, Boolean>();
        for (String path : fileLockUtil.lockFiles()) {
            lockStateMap.put(path, true);
        }
        for (String path : fileLockUtil.lockFailFiles()) {
            lockStateMap.put(path, false);
        }
        ArrayList<String[]> lockListItems = new ArrayList<String[]>();
        for (Map.Entry entry : lockStateMap.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) {
                lockListItems.add(new String[]{ResourceUtil.get("message.lock"), (String)entry.getKey()});
                continue;
            }
            lockListItems.add(new String[]{ResourceUtil.get("message.fail"), (String)entry.getKey()});
        }
        this.lockTable = new JTable((Object[][])lockListItems.toArray((T[])new String[0][]), new String[]{"State", "Path"});
        this.lockTable.setAutoResizeMode(0);
        JScrollPane lockTableScroll = new JScrollPane(this.lockTable);
        l.putConstraint("South", (Component)lockTableScroll, -10, "North", (Component)closeButton);
        l.putConstraint("North", (Component)lockTableScroll, 10, "North", (Component)c);
        l.putConstraint("East", (Component)lockTableScroll, -10, "East", (Component)c);
        l.putConstraint("West", (Component)lockTableScroll, 10, "West", (Component)c);
        c.add(lockTableScroll);
    }

    private void columnResize() {
        FontMetrics fm = this.getGraphics().getFontMetrics();
        for (int columnIndex = 0; columnIndex < this.lockTable.getColumnCount(); ++columnIndex) {
            int maxSize = 0;
            for (int rowIndex = 0; rowIndex < this.lockTable.getRowCount(); ++rowIndex) {
                int s = fm.stringWidth((String)this.lockTable.getValueAt(rowIndex, columnIndex));
                if (s <= maxSize) continue;
                maxSize = s;
            }
            this.lockTable.getColumnModel().getColumn(columnIndex).setPreferredWidth(maxSize);
        }
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                JOptionPane.showMessageDialog(null, e.toString(), "Error", 0);
            }
        });
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        SwingMain one = new SwingMain(args);
        one.setVisible(true);
        one.columnResize();
    }
}

