#include "defextern.h"

#include "myfilemv.h"
#include "initial.h"

BOOL isclip(char *d)
{
	return (strncmp(_CLIP, d, _ClipLen)==0) ;
}

BOOL dirw::isclip()
{
	return ::isclip(dir);
}


char clipdirfile[MAX_PATH];
#define keydir "dir"
#define keydirnum "num"

// clip:abc  >> abc.ini ɐݒ

void initclip(char *dir)
{
	sprintf(clipdirfile,"%s\\%s.ini",getCdir(), dir+5);
}

// clipǉ
//
// clip
//   [num]
//   num=1
//   [dir]
//   1=c:\... etc.

BOOL addclip(char *from, char *to)
{
	if(strlen(to)<=_ClipLen) return FALSE;
	initclip(to);
	int num =GetPrivateProfileInt(keydirnum, keydirnum, 0, clipdirfile);

	num++;
	char buf[10];
	sprintf(buf, "%d", num);
	WritePrivateProfileString(keydir, buf, from, clipdirfile);
	WritePrivateProfileString(keydirnum, keydirnum, buf, clipdirfile);
	return TRUE;
}


void openClip(char *dir)
{
	initclip(dir);
	//GetPrivateProfileString(keydir, "", "", buffer, MAX_PATH, clipdirfile);

	return;
}

void Exchange(dirw &ldir, dirw &rdir)
{
	/*
	char buf[1000];
	ldir.GetCurrentDirectory(1000,buf);
	ldir.SetCurrentDirectory(rdir.cd());
	rdir.SetCurrentDirectory(buf);
	*/
	HWND ledit=ldir.getEdit();
	HWND llist=ldir.getList();
	HWND redit=rdir.getEdit();
	HWND rlist=rdir.getList();
	dirw dir=ldir;

	ldir =rdir;
	rdir =dir;

	ldir.setList(llist);
	rdir.setList(rlist);
	ldir.setEdit(ledit);
	rdir.setEdit(redit);
}

void dirw::savedir()
{
	savehisdir(tab, dir);
};


int dirw::getClipMax()
{
	clipmax =GetPrivateProfileInt(keydirnum, keydirnum, 0, clipdirfile);
	return clipmax;
}

char *dirw::getClip(int num)
{
	static char buf[10], ans[MAX_PATH];
	sprintf(buf, "%d", num);
	GetPrivateProfileString(keydir, buf, "", ans, MAX_PATH, clipdirfile);
	return ans;
}

char *dirw::SetCurrentDirectory(char *d)
{
	//
	BOOL f=FALSE;
	if( isclip() && d==".") return dir;
	if( ::isclip(d) ) 
	{
		sprintf(dir, d);
		space=0;
		total=0;
		openClip(dir);
		return dir;
	}

	if(strcmp(dir,d)==0 && strlen(d)>0) f=TRUE;
	::SetCurrentDirectory(dir);
	::SetCurrentDirectory(d);
	::GetCurrentDirectory(1000,dir);
	sprintf(drive,"%s",dir);
	if(!f && strlen(d)>0) savedir();
	char *p =strchr( drive,'\\' );
	if (p !=NULL ) if(strlen(p) >1 ) p[1]=0;
	int i=GetDiskFreeSpaceEx( drive, &FreeBytesAv,
		&Bytes,
		&FreeBytes);
//	(double)FreeAvBytes.u.HighPart*4294967296.0 + (double)FreeAvBytes.u.LowPart
	if(i) 
	{
		space =((double)(FreeBytesAv.u.LowPart)+
			(double)FreeBytesAv.u.HighPart*4294967296.0)/1024/1024;
		total =((double)(Bytes.u.LowPart)+
			(double)Bytes.u.HighPart*4294967296.0)/1024/1024;
	}
	//space =(double)NumberOfFreeClusters *SectorsPerCluster *BytesPerSector/1024/1024;
	else {space =0;total =0;};
	return dir;
};

void dirw::hisback()
{
	hispos(-1);
	cd(dir);
};
void dirw::hispos(int i)
{
	loadhisdir(tab, dir, i);
}