
#include "defextern.h"

#ifndef STRICT
    #define STRICT
#endif
#include <windows.h>
#include <commctrl.h>
#include "resource.h"
#include "myfilemv.h"
#include "initial.h"
#include "listview.h"
#include "paintflag.h"
#include "status.h"
#include "file.h"
#include "mouseg.h"


int lcx[] ={100,40,70,120,20};//
posi pos(0,2,3,4,-1,1);//ʒu

char extpaint[10];


void setExtPaint(char *txt)
{
	if(strlen(txt)<5) strcpy(extpaint, txt);
}

void setExtPaint(HWND list)
{
	int iIndex = ListView_GetNextItem(list, -1, LVNI_SELECTED);
	ListView_GetItemText(list, iIndex, pos.ext, extpaint, ListItemLen);
}



int CALLBACK MyCompProc(LPARAM lp1, LPARAM lp2, LPARAM lp3)
{
    static LVFINDINFO lvf;
    static int nItem1, nItem2;
    static char buf1[MAX_PATH], buf2[MAX_PATH];
    SORTDATA *lpsd;

    lpsd = (SORTDATA *)lp3;

    lvf.flags = LVFI_PARAM;
    lvf.lParam = lp1;
    nItem1 = ListView_FindItem(lpsd->hwndList, -1, &lvf);

    lvf.lParam = lp2;
    nItem2 = ListView_FindItem(lpsd->hwndList, -1, &lvf);
    
    ListView_GetItemText(lpsd->hwndList,
        nItem1, lpsd->isortSubItem, buf1, sizeof(buf1));

    ListView_GetItemText(lpsd->hwndList,
        nItem2, lpsd->isortSubItem, buf2, sizeof(buf2));
    if (lpsd->isortSubItem != pos.size && lpsd->isortSubItem != pos.stat) {
        if (lpsd->iUPDOWN == UP) {
            return(stricmp(buf1, buf2));
        } else {
            return(stricmp(buf1, buf2) * -1);
        }
    } else {
        if (lpsd->iUPDOWN == UP) {
            if (atof(buf1) > atof(buf2))//strtod
                return 1;
            else if (atof(buf1) == atof(buf2))
                return 0;
            else
                return -1;
        } else {
            if (atof(buf1) > atof(buf2))
                return -1;
            else if (atof(buf1) == atof(buf2))
                return 0;
            else
                return 1;
        }

    }
}

void ListSelected(HWND hList, int i, BOOL fl)
{
	if(fl) 
	{
		ListView_SetItemState( hList, i, LVIS_SELECTED, LVIS_SELECTED);
	}
	else 
	{
		ListView_SetItemState( hList, i, 0, LVIS_SELECTED);
	}
}

void ListNonSelected( HWND hList )
{
	int i =0;
	int max =ListView_GetItemCount( hList );
	while( i< max )
	{
		ListView_SetItemState( hList, i, 0, LVIS_SELECTED);
		i++;
	}
}

int LGetSelectedCount( HWND hList )
{
	int i =-1;
	int co=0;
	int max =ListView_GetItemCount( hList );
	while( 1 )
	{
		i = ListView_GetNextItem( hList, i, LVNI_ALL | LVNI_SELECTED);
		if ( i ==-1) break;
		co++;
	}
	return co;
}

COLORREF midcolor( DWORD ctxt, DWORD cbk )
{
	static COLORREF cc;
	BYTE bl=GetGValue(ctxt);//255
	return RGB( GetRValue(ctxt)/2 + GetRValue(cbk)/2, GetGValue(ctxt)/2 + GetGValue(cbk)/2, bl );
}


void initlistcolor()
{
	//listtextcolor =ListView_GetTextColor(hwnd);
	//listtextbkcolor =ListView_GetTextBkColor(hwnd);
	//ListView_SetTextBkColor(hwnd,0);
	//ListView_SetTextColor(hwnd,0xffff);
	listtextColor =RGB(255,255,255);//GetSysColor(COLOR_WINDOW);
	listtextBkColor =RGB(0,0,0);//GetSysColor(COLOR_BACKGROUND);
	listtextSpColor =midcolor(listtextColor,listtextBkColor);
	//paintf =PAINTFLAG_DEF;
}



void colorRev(HWND hList)
{
	listtextBkColor =ListView_GetTextBkColor(hList);
	listtextColor =ListView_GetTextColor(hList);
	COLORREF cr =listtextColor;
	listtextColor =listtextBkColor;
	listtextBkColor =cr;
	listtextSpColor =midcolor(listtextColor,listtextBkColor);
}

void setlistcolor(HWND hList)
{
	SetBkMode(GetDC(hList), TRANSPARENT);
	ListView_SetTextBkColor(hList,listtextBkColor);
	ListView_SetTextColor(hList,listtextColor);
}

void sortlist( HWND hList, int num )
{
	num--;
    static int sortsubno[NO_OF_SUBITEM] = {UP};
	if (sortsubno[num] == UP)
		sortsubno[num] = DOWN;
	else
		sortsubno[num] = UP;
	SORTDATA SortData;
	SortData.hwndList = hList;
	SortData.isortSubItem = num;
	SortData.iUPDOWN = sortsubno[num];
	ListView_SortItems(hList, MyCompProc, &SortData);
}

void getftime(WIN32_FIND_DATA &wfd, char *txt)
{
    SYSTEMTIME localtm;
    FILETIME localft;
	FileTimeToLocalFileTime(&wfd.ftLastWriteTime, &localft);
    FileTimeToSystemTime(&localft, &localtm);
    wsprintf(txt, "%02d/%02d/%02d %02d:%02d:%02d.%03d",
        localtm.wYear, localtm.wMonth, localtm.wDay, localtm.wHour, localtm.wMinute, localtm.wSecond, localtm.wMilliseconds);
}



#define _normal 0
#define _clipmode 1

char blank[]=" ";//""ɂƌAtH_ɐFĂ܂


// mouse gesture

void AddListItem(HWND hList, char *szfname, int &iItemNo, int id)
{
	LVITEM li;
	char item[MAX_PATH];
	wsprintf(item, "%d",id);
    li.mask = topmask;
	li.iImage = NO_IMAGE;//FILE_IMAGE;
    li.pszText = szfname;
    li.iItem = iItemNo;
    li.iSubItem = pos.name;
    li.lParam = iItemNo;
	

	li.iImage = FILE_IMAGE;

    ListView_InsertItem(hList, &li);

    li.mask = LVIF_TEXT;
    li.iSubItem = pos.size;
    strcpy(li.pszText, item);
    ListView_SetItem(hList, &li);

    li.iSubItem = pos.date;
    strcpy(li.pszText, mgTransRev(item));
    ListView_SetItem(hList, &li);

    if(strlen(li.pszText)>0) strcpy(li.pszText, ".");
	else strcpy(li.pszText, "");
    li.iSubItem = pos.stat;
    ListView_SetItem(hList, &li);

    li.iSubItem = pos.ext;
    ListView_SetItem(hList, &li);

    iItemNo++;
}

void AddListItem(HWND hList, HANDLE hFind, char *szfname, WIN32_FIND_DATA &wfd, LVITEM &li, int &iItemNo, char *item)
{
    char szBuf[MAX_PATH];
    char ext[MAX_PATH]=defExtPaint;
	char *p;
	BOOL dirf;
	strcpy(szfname, wfd.cFileName);
	if(item!=NULL) strcpy(szfname, item);
    li.mask = topmask;
	li.iImage = NO_IMAGE;//FILE_IMAGE;
    li.pszText = szfname;
    li.iItem = iItemNo;
    li.iSubItem = pos.name;
    li.lParam = iItemNo;
	
	dirf =wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY;
	p=strrchr(szfname,'.');
	if(!dirf && p!=NULL) strcpy(ext, p);
	else  strcpy(ext, blank);

//#ifdef Icon
	if (dirf) {
		li.iImage = DIRECTORY_IMAGE;
	} else {
		li.iImage = FILE_IMAGE;
	}
//#endif

    ListView_InsertItem(hList, &li);

    li.mask = LVIF_TEXT;
    li.iSubItem = pos.size;
    if (!( dirf )) {
		wsprintf(li.pszText, "%u", wfd.nFileSizeLow);
        //itoa(wfd.nFileSizeLow, li.pszText, 10);
        if (wfd.nFileSizeHigh != 0)
            setstatus("t@CTCY傫܂");
    } else {
        strcpy(li.pszText, isdirectory);
    }
    ListView_SetItem(hList, &li);

	getftime(wfd, li.pszText);
    li.iSubItem = pos.date;
    ListView_SetItem(hList, &li);

    wsprintf(li.pszText, "%d", wfd.dwFileAttributes);
    li.iSubItem = pos.stat;
    ListView_SetItem(hList, &li);


	/*
    GetShortPathName(wfd.cFileName, szBuf, sizeof(szBuf));
    strcpy(li.pszText, szBuf);
    li.iSubItem = pos.dname;
    ListView_SetItem(hList, &li);
	*/
    //strcpy(li.pszText, p);
    li.iSubItem = pos.ext;
    li.pszText = ext;
    ListView_SetItem(hList, &li);

    iItemNo++;
}

void InsertMyColumn(HWND hList)
{
    LVCOLUMN lc;//FORWARD_WM_NOTIFY

    lc.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
    lc.fmt = LVCFMT_LEFT;
    lc.cx = lcx[pos.name];
    lc.pszText = "t@C";
    lc.iSubItem = pos.name;
    ListView_InsertColumn(hList, pos.name, &lc);

    lc.fmt = LVCFMT_LEFT;
    lc.cx = lcx[pos.ext];
    lc.pszText = ""; // gq
    lc.iSubItem = pos.ext;
    ListView_InsertColumn(hList, pos.ext, &lc);

    lc.fmt = LVCFMT_RIGHT;
    lc.cx = lcx[pos.size];
    lc.pszText = "TCY";
    lc.iSubItem = pos.size;
    ListView_InsertColumn(hList, pos.size, &lc);

    lc.fmt = LVCFMT_LEFT;
    lc.cx = lcx[pos.date];
    lc.pszText = "XV";
    lc.iSubItem = pos.date;
    ListView_InsertColumn(hList, pos.date, &lc);

    lc.fmt = LVCFMT_RIGHT;
    lc.cx = lcx[pos.stat];
    lc.pszText = "";
    lc.iSubItem = pos.stat;
    ListView_InsertColumn(hList, pos.stat, &lc);

    return;
}
/*
void setlw(HWND list, int id)
{
    LVCOLUMN lc;
    lc.cx = lcx[id];
    lc.iSubItem = id;
	ListView_SetColumn(list, id, &lc);
}

void SetListWidth(HWND list, int wi)
{
	double sum =double(pos.stat +pos.name +pos.date +pos.size +pos.ext)/wi;
	setlw(list, ((double) pos.stat)/sum);
	setlw(list, ((double) pos.name)/sum);
	setlw(list, ((double) pos.date)/sum);
	setlw(list, ((double) pos.size)/sum);
	setlw(list, ((double) pos.ext)/sum);
}
*/
void AddListDrive(HWND hList, char *szfname, char *fnameback, LVITEM &li, int &iItemNo)
{
	char c='a';
	while(1)
	{
		wsprintf(szfname, "%c:\\",c);
		SetCurrentDirectory(szfname);
		GetCurrentDirectory(MAX_PATH, szfname);
		if((toupper(szfname[0])==toupper(c)) && (toupper(fnameback[0])!=toupper(c)))
		{
			li.iSubItem = pos.name;
			li.pszText =szfname;

		//	if (iconf)
				li.iImage = DRIVE_IMAGE;
			li.mask = topmask;
			li.iItem = iItemNo;
			li.lParam = iItemNo;
			ListView_InsertItem(hList, &li);

			li.iSubItem = pos.size;
			li.mask = LVIF_TEXT;
			strcpy(li.pszText, isdirectory);
			ListView_SetItem(hList, &li);

		}
		if(c>'z') break;
		c++;
	}
}

extern menuMouse menuMg;
extern HMENU hMainMenu;

// }EXWFX`EXg ǂݍݖ{


int SetMyMouseGestureList(HWND hWnd, dirw &dir, HWND hDirEdit, HIMAGELIST hImage)
{
	menuMg.init(hMainMenu);
	SetWindowText(hDirEdit, dir.cd());
	HWND hList =dir.getList();

	return menuMg.addlist( hList);
}



// NbvEXg ǂݍݖ{

int SetMyClipList(HWND hWnd, dirw &dir, HWND hDirEdit, HIMAGELIST hImage)
{
	SetWindowText(hDirEdit, dir.cd());
	char szfname[MAX_PATH], item[MAX_PATH];
    char ext[MAX_PATH]=defExtPaint;
	BOOL dirf =FALSE;
	HWND hList =dir.getList();
	LVITEM li;
	char *p;
	int i;
	HANDLE fi;
	WIN32_FIND_DATA wfd;

	for(i=0; i<dir.getClipMax(); i++) {
		int ino =i;
		wsprintf(item,"%s", dir.getClip(i+1));
		if (strlen(item)==0) continue;
		fi =getHandle(item);
		fi = FindFirstFile(dir.getClip(i+1), &wfd);
		AddListItem( hList, fi, szfname, wfd, li, ino, item);
		FindClose(fi);
	}
	return i;
}

// t@CXg ǂݍݖ{, tB^[filefilterŐݒ

int SetMyLocalDir(HWND hWnd, dirw &dir, HIMAGELIST hImage)
{
    char szfname[MAX_PATH + 5],szfnameback[MAX_PATH + 5];
    WIN32_FIND_DATA wfd;
	HWND hList =dir.getList();
	HWND hDirEdit =dir.getEdit();
    HANDLE hFind;
    int iItemNo = 0;
    LVITEM li;
	BOOL rootflag=FALSE;

    ListView_DeleteAllItems(hList);
	// clip,  ǂݍ
    if( dir.isclip() || dir.ishis()  ) 
	{
		return SetMyClipList(hWnd, dir, hDirEdit, hImage);
	}
	// }EXWFX`ݒ@ǂݍ
    if( dir.ismouse()  ) 
	{
		return SetMyMouseGestureList(hWnd, dir, hDirEdit, hImage);
	}
 	SetCurrentDirectory( dir.cd() );
	GetCurrentDirectory(MAX_PATH, szfname);
	SetWindowText(hDirEdit, szfname);
//	Mes(szfname);
	strcpy(szfnameback,szfname);
	if(strlen(szfname)<4) rootflag=TRUE;//[g`FbN@蔲
    
    hFind = FindFirstFile(filefilter, &wfd);
    if (hFind == INVALID_HANDLE_VALUE) {
        setstatus("܂");
        FindClose(hFind);
        return 0;
    } else {
        AddListItem( hList, hFind, szfname, wfd, li, iItemNo);
    }

    while (FindNextFile(hFind, &wfd)) {
		AddListItem( hList, hFind, szfname, wfd, li, iItemNo);
    }
    FindClose(hFind);

	//hCu\A蔲ia-zj
	if(rootflag)
	{
		AddListDrive( hList, szfname, szfnameback, li, iItemNo);
		SetCurrentDirectory(szfnameback);//̈ʒuɖ߂
	}

	localitemnum=iItemNo;
    return iItemNo;
}


