/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */
package jp.finaluna.api.type;

import jp.finaluna.api.blogic.BLogicCode;
import jp.finaluna.api.blogic.DAOCode;
import jp.finaluna.api.blogic.DTOCode;
import jp.finaluna.api.dao.DAO;
import jp.finaluna.api.dao.QueryCode;
import jp.finaluna.api.dto.DTO;

/**
 * Finaluna^𐶐ׂ̃t@NgB
 * 
 * <p>
 * ƖWbNNXFinaluna^tB[hɊi[CX^X́AConstantFactroyNXpĐB
 * </p>
 * 
 * <pre>
 * )
 * public class Blogic impliments logic {
 * private static final StringCode stringCode = ConstantFactory.createStringCode(&quot;STRING&quot;);
 * </pre>
 * 
 * @version $Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $
 * @author NTTf[^
 */
@Rcsid("$Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $")
public class ConstantFactory {
    /**
     * Finaluna^NXB
     */
    private static ConstantFactoryDelegate typeFactory = null;

    /**
     * ftHgRXgN^
     */
    protected ConstantFactory() {
    }

    /**
     * Finaluna^NXݒ肷B
     * 
     * @param factory ConstantFactoryDelegate
     */
    public static void setTypeFactory(ConstantFactoryDelegate factory) {
        typeFactory = factory;
    }

    /**
     * DateAndTimeType𐶐B
     * 
     * @param value l
     * @return DateAndTimeType
     */
    public static DateAndTimeType createDateAndTimeType(String value) {
        return typeFactory.createDateAndTimeType(value);
    }

    /**
     * DateType𐶐B
     * 
     * @param value l
     * @return DateType
     */
    public static DateType createDateType(String value) {
        return typeFactory.createDateType(value);
    }

    /**
     * DecimalType𐶐B
     * 
     * @param value l
     * @return DecimalType
     */
    public static DecimalType createDecimalType(String value) {
        return typeFactory.createDecimalType(value);
    }

    /**
     * IntegerType𐶐B
     * 
     * @param value l
     * @return IntegerType
     */
    public static IntegerType createIntegerType(String value) {
        return typeFactory.createIntegerType(value);
    }

    /**
     * StringType𐶐B
     * 
     * @param value l
     * @return StringType
     */
    public static StringType createStringType(String value) {
        return typeFactory.createStringType(value);
    }

    /**
     * StringCode𐶐B
     * 
     * @param value l
     * @return StringCode
     */
    public static StringCode createStringCode(String value) {
        return typeFactory.createStringCode(value);
    }

    /**
     * TimestampType𐶐B
     * 
     * @param value l
     * @return TimestampType
     */
    public static TimestampType createTimestampType(String value) {
        return typeFactory.createTimestampType(value);
    }

    /**
     * TimeType𐶐B
     * 
     * @param value l
     * @return TimeType
     */
    public static TimeType createTimeType(String value) {
        return typeFactory.createTimeType(value);
    }

    /**
     * BLogicCode𐶐B
     * 
     * @param <REQ> DTO
     * @param <RES> DTO
     * @param value l
     * @return BLogicCode
     */
    public static < REQ extends DTO, RES extends DTO > BLogicCode < REQ, RES > createBLogicCode(String value) {
        return typeFactory.createBLogicCode(value);
    }

    /**
     * DAOCode𐶐B
     * 
     * @param <T> DAO
     * @param value l
     * @return DAOCode
     */
    public static < T extends DAO > DAOCode < T > createDAOCode(String value) {
        return typeFactory.createDAOCode(value);
    }

    /**
     * DTOCode𐶐B
     * 
     * @param <T> DTO
     * @param value l
     * @return DTOCode
     */
    public static < T extends DTO > DTOCode < T > createDTOCode(String value) {
        return typeFactory.createDTOCode(value);
    }

    /**
     * QueryCode𐶐B
     * 
     * @param <T> DTO
     * @param value l
     * @return QueryCode
     */
    public static < T extends DTO > QueryCode < T > createQueryCode(String value) {
        return typeFactory.createQueryCode(value);
    }

}
