/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */

package jp.finaluna.api.type;

import jp.finaluna.api.type.util.DateUtil;
import jp.finaluna.api.type.util.MathUtil;

/**
 * bێ^B
 * <p>
 * ̔rAҏW\bhB ɕێ͎bBN̒ĺAJava.util.CalendarNX̊ԂێB ̌^ێ͎tB[hłAPʂ傫ttB[h
 * ̏͏B ܂ÃNX̗p҂͓ttB[hCɂ邱ƂȂA Ȏibĵ݂rA܂͌vZʂ擾邱ƂłB̌^̕\HH:mm:ssłB
 * </p>
 * 
 * @version $Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $
 * @author NTTf[^
 */
@Rcsid("$Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $")
public interface TimeType extends BaseType, Comparable < TimeType >, Copiable < TimeType > {

    /**
     * <p>
     * ̎̓ttB[hɑ΂Aw肳ꂽlŉZsB
     * </p>
     * )10ԑꍇ́A<br>
     * 
     * <pre>
     * add(DateUtil.HOUR_OF_DAY, 10);
     * </pre>
     * 
     * @param field ttB[h
     * @param amount Zl
     * @return Zs^
     */
    TimeType add(DateUtil.Calendar field, int amount);

    /**
     * <p>
     * ̎̓ttB[hɑ΂Aw肳ꂽlŉZsB
     * </p>
     * 
     * @param field ttB[h
     * @param amount Zl
     * @return Zs^
     */
    TimeType add(DateUtil.Calendar field, IntegerType amount);

    /**
     * <p>
     * ̎Aw肵ɂ邩ǂ𔻒肷B
     * </p>
     * <p>
     * <code>compareTime</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param compareTime rΏێ
     * @return rΏێɂꍇA<code>true</code><br>
     *         rΏێOɂꍇA<code>false</code><br>
     *         rΏێƓꍇA<code>false</code>
     */
    boolean isAfter(TimeType compareTime);

    /**
     * <p>
     * ̎Aw肵Oɂ邩ǂ𔻒肷B
     * </p>
     * <p>
     * <code>compareTime</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param compareTime rΏێ
     * @return rΏێOɂꍇA<code>true</code><br>
     *         rΏێɂꍇA<code>false</code><br>
     *         rΏێƓꍇA<code>false</code>
     */
    boolean isBefore(TimeType compareTime);

    /**
     * <p>
     * ̎Aw肳ꂽlAElŔ͈͓ɂ邩ǂ肷B
     * </p>
     * <p>
     * JnAI̋EĺA<code>range</code>Ɏw肳ꂽElɏ]B
     * </p>
     * 
     * @param startTime Jn
     * @param endTime I
     * @param range El
     * @return w肳ꂽlElŔ͈͓ɂꍇA<code>true</code><br>
     *         ȊȌꍇ <code>false</code>
     */
    boolean isInRange(TimeType startTime, TimeType endTime, MathUtil.InRange range);

    /**
     * <p>
     * ̎Aw肵ɂ邩ǂ𔻒肷B
     * </p>
     * <p>
     * <code>compareTime</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param compareTime rΏێ
     * @return rΏێɂꍇA<code>true</code><br>
     *         rΏێOɂꍇA<code>false</code><br>
     *         rΏێƓꍇA<code>true</code>
     */
    boolean isOnAndAfter(TimeType compareTime);

    /**
     * <p>
     * ̎Aw肵Oɂ邩ǂ𔻒肷B
     * </p>
     * <p>
     * <code>compareTime</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param compareTime rΏێ
     * @return rΏێOɂꍇA<code>true</code><br>
     *         rΏێɂꍇA<code>false</code><br>
     *         rΏێƓꍇA<code>true</code>
     */
    boolean isOnAndBefore(TimeType compareTime);

    /**
     * <p>
     * ̎̎wtB[hɑ΂Aw肳ꂽlݒ肷B
     * </p>
     * )22ݒ肷B<br>
     * 
     * <pre>
     * set(DateUtil.HOUR_OF_DAY, 22);
     * </pre>
     * 
     * @param field ttB[h
     * @param amount ݒ肷l
     * @return ݒ肵^
     */
    TimeType set(DateUtil.Calendar field, int amount);

    /**
     * <p>
     * ̎̎wtB[hɑ΂Aw肳ꂽlݒ肷B
     * </p>
     * 
     * @param field ttB[h
     * @param amount ݒ肷l
     * @return ݒ肵^
     */
    TimeType set(DateUtil.Calendar field, IntegerType amount);

    /**
     * <p>
     * ̎̎wtB[h擾B
     * </p>
     * 
     * @param field ttB[h
     * @return w肵tB[h̒l
     */
    int get(DateUtil.Calendar field);
}
