/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */
package jp.finaluna.api.type.util;

import jp.finaluna.api.exception.FinalunaApplException;
import jp.finaluna.api.type.CodeType;
import jp.finaluna.api.type.DateAndTimeType;
import jp.finaluna.api.type.DateType;
import jp.finaluna.api.type.DecimalType;
import jp.finaluna.api.type.IntegerType;
import jp.finaluna.api.type.KeyCodeType;
import jp.finaluna.api.type.Rcsid;
import jp.finaluna.api.type.StringCode;
import jp.finaluna.api.type.StringType;
import jp.finaluna.api.type.TimeType;
import jp.finaluna.api.type.TimestampType;

/**
 * javaFINALUNA^ݕϊ[eBeBNXB
 * <p>
 * javaFINALUNA^ݕϊ̃[eBeBB
 * </p>
 * 
 * @version $Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $
 * @author NTTf[^
 */
@Rcsid("$Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $")
public class ConvertUtil {

    /**
     * Finaluna^NXB
     */
    private static ConvertUtilDelegate convertUtil = null;

    /**
     * RXgN^B
     */
    protected ConvertUtil() {
        super();
    }

    /**
     * <code>CodeType</code><code>String<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static String toString(CodeType target) {
        return convertUtil.toString(target);
    }

    /**
     * <code>KeyCodeType</code><code>String<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static String toString(KeyCodeType target) {
        return convertUtil.toString(target);
    }

    /**
     * <code>StringType</code><code>String<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static String toString(StringType target) {
        return convertUtil.toString(target);
    }

    /**
     * <code>IntegerType</code><code>int<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static int intValue(IntegerType target) {
        return convertUtil.intValue(target);
    }

    /**
     * <code>IntegerType</code><code>int<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     * @throws FinalunaApplException ꂽ񂪂ꍇAFinalunaApplExceptionX[B
     */
    public static int intValueExact(IntegerType target) throws FinalunaApplException {
        return convertUtil.intValueExact(target);
    }

    /**
     * <code>IntegerType</code><code>String<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static String toString(IntegerType target) {
        return convertUtil.toString(target);
    }

    /**
     * <code>DecimalType</code><code>int<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static int intValue(DecimalType target) {
        return convertUtil.intValue(target);
    }

    /**
     * <code>DecimalType</code><code>int<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     * @throws FinalunaApplException ꂽ񂪂ꍇAFinalunaApplExceptionX[B
     */
    public static int intValueExact(DecimalType target) throws FinalunaApplException {
        return convertUtil.intValueExact(target);
    }

    /**
     * <code>DecimalType</code><code>String<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static String toString(DecimalType target) {
        return convertUtil.toString(target);
    }

    /**
     * <code>String</code><code>CodeType<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static CodeType toCodeType(String target) {
        return convertUtil.toCodeType(target);
    }

    /**
     * <code>String</code><code>KeyCodeType<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static KeyCodeType toKeyCodeType(String target) {
        return convertUtil.toKeyCodeType(target);
    }

    /**
     * <code>String</code><code>StringType<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static StringType toStringType(String target) {
        return convertUtil.toStringType(target);
    }

    /**
     * <code>int</code><code>IntegerType<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static IntegerType toIntegerType(int target) {
        return convertUtil.toIntegerType(target);
    }

    /**
     * <code>String</code><code>IntegerType<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static IntegerType toIntegerType(String target) {
        return convertUtil.toIntegerType(target);
    }

    /**
     * <code>String</code><code>IntegerType<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     * @throws FinalunaApplException ꂽ񂪂ꍇAFinalunaApplExceptionX[B
     */
    public static IntegerType toIntegerTypeExact(String target) throws FinalunaApplException {
        return convertUtil.toIntegerTypeExact(target);
    }

    /**
     * <code>int</code><code>DecimalType<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static DecimalType toDecimalType(int target) {
        return convertUtil.toDecimalType(target);
    }

    /**
     * <code>String</code><code>DecimalType<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static DecimalType toDecimalType(String target) {
        return convertUtil.toDecimalType(target);
    }

    /**
     * <code>String</code><code>DecimalType<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     * @throws FinalunaApplException ꂽ񂪂ꍇAFinalunaApplExceptionX[B
     */
    public static DecimalType toDecimalTypeExact(String target) throws FinalunaApplException {
        return convertUtil.toDecimalTypeExact(target);
    }

    /**
     * <code>String</code><code>DateType<code>ɕϊB
     * 
     * <p>
     * DateTypeێ͔N̂߁AN̂ݐݒ肳B
     * wtH[}bgFyyyy-MM-dd <br/>
     * target̐ݒF2009-10-10
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static DateType toDateType(String target) {
        return convertUtil.toDateType(target);
    }

    /**
     * <code>String</code><code>TimeType<code>ɕϊB
     * 
     * <p>
     * TimeTypeێ͎b̂߁Ab̂ݐݒ肳B
     * wtH[}bgFHH:mm:ss <br/>
     * target̐ݒF10:20:30
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static TimeType toTimeType(String target) {
        return convertUtil.toTimeType(target);
    }

    /**
     * <code>String</code><code>TimestampType<code>ɕϊB
     * 
     * <p>
     * wtH[}bgFyyyy-MM-dd HH:mm:ss or yyyy-MM-dd HH:mm:ss.S`S (9ȓ) <br/>
     * target̐ݒF2009-10-10 10:20:30
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static TimestampType toTimestampType(String target) {
        return convertUtil.toTimestampType(target);
    }

    /**
     * <code>String</code><code>DateAndTimeType<code>ɕϊB
     * 
     * <p>
     * wtH[}bgFyyyy-MM-dd HH:mm:ss <br/>
     * target̐ݒF2009-10-10 10:20:30
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static DateAndTimeType toDateAndTimeType(String target) {
        return convertUtil.toDateAndTimeType(target);
    }

    /**
     * <code>StringCode</code><code>String<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static String toString(StringCode target) {
        return convertUtil.toString(target);
    }

    /**
     * <code>String</code><code>StringCode<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static StringCode toStringCode(String target) {
        return convertUtil.toStringCode(target);
    }

    /**
     * javaFINALUNA^ݕϊNXݒ肷B
     * 
     * @param convertUtilDelegate ConvertUtilDelegate
     */
    public static void setConvertUtil(ConvertUtilDelegate convertUtilDelegate) {
        convertUtil = convertUtilDelegate;
    }
}
