/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */
package jp.finaluna.api.type.util;

import jp.finaluna.api.exception.FinalunaApplException;
import jp.finaluna.api.type.DateAndTimeType;
import jp.finaluna.api.type.DateType;
import jp.finaluna.api.type.DecimalType;
import jp.finaluna.api.type.IntegerType;
import jp.finaluna.api.type.Rcsid;
import jp.finaluna.api.type.StringCode;
import jp.finaluna.api.type.TimeType;
import jp.finaluna.api.type.TimestampType;

/**
 * FINALUNA^Ԃ̑ݕϊs߂̌^ϊ[eBeBNXB
 * <p>
 * FINALUNA^FINALUNA^ݕϊ̃[eBeBB
 * </p>
 * 
 * @author NTTf[^
 * @version $Revision: 38309 $ $Date: 2010-03-18 17:14:55 +0900 $
 */
@Rcsid("$Revision: 38309 $ $Date: 2010-03-18 17:14:55 +0900 $")
public class FinalunaTypeConvertUtil {

    /**
     * ϊpCX^XB
     */
    private static FinalunaTypeConvertUtilDelegate convertUtil = null;
    
    /**
     * RXgN^B
     */
    private FinalunaTypeConvertUtil() {
        super();
    }

    /**
     * <code>StringCode</code><code>IntegerType</code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static IntegerType toIntegerType(StringCode target) {
        return convertUtil.toIntegerType(target);
    }
    
    /**
     * <code>StringCode</code><code>IntegerType</code>ɕϊB
     * <p>
     * ϊɍۂꂽ񂪂ꍇA<code>FinalunaApplException</code>X[B
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     * @throws FinalunaApplException ϊɍۂꂽ񂪂ꍇ
     */
    public static IntegerType toIntegerTypeExact(StringCode target) throws FinalunaApplException {
        return convertUtil.toIntegerTypeExact(target);
    }
    
    /**
     * <code>StringCode</code><code>DecimalType</code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static  DecimalType toDecimalType(StringCode target) {
        return convertUtil.toDecimalType(target);
    }
    
    /**
     * <code>IntegerType</code><code>DecimalType</code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static DecimalType toDecimalType(IntegerType target) {
        return convertUtil.toDecimalType(target);
    }
    
    /**
     * <code>StringCode</code><code>DecimalType</code>ɕϊB
     * <p>
     * ϊɍۂꂽ񂪂ꍇA<code>FinalunaApplException</code>X[B
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     * @throws FinalunaApplException ϊɍۂꂽ񂪂ꍇ
     */
    public static DecimalType toDecimalTypeExact(StringCode target) throws FinalunaApplException {
        return convertUtil.toDecimalTypeExact(target);
    }
    
    /**
     * <code>StringCode</code><code>DateAndTimeType</code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static DateAndTimeType toDateAndTimeType(StringCode target) {
        return convertUtil.toDateAndTimeType(target);
    }
    
    /**
     * <code>DateType</code><code>DateAndTimeType</code>ɕϊB
     * <p>
     * b00:00:00Őݒ肷B
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static DateAndTimeType toDateAndTimeType(DateType target) {
        return convertUtil.toDateAndTimeType(target);
    }
    
    /**
     * <code>TimestampType</code><code>DateAndTimeType</code>ɕϊB
     * <p>
     * imb͐؂̂ĂB
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static DateAndTimeType toDateAndTimeType(TimestampType target) {
        return convertUtil.toDateAndTimeType(target);
    }
    
    /**
     * <code>StringCode</code><code>DateType</code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static DateType toDateType(StringCode target) {
        return convertUtil.toDateType(target);
    }
    
    /**
     * <code>DateAndTimeType</code><code>DateType</code>ɕϊB
     * <p>
     * b͐؂̂ĂB
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static DateType toDateType(DateAndTimeType target) {
        return convertUtil.toDateType(target);
    }
    
    /**
     * <code>TimestampType</code><code>DateType</code>ɕϊB
     * <p>
     * bimb͐؂̂ĂB
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static DateType toDateType(TimestampType target) {
        return convertUtil.toDateType(target);
    }
    
    /**
     * <code>StringCode</code><code>TimestampType</code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static TimestampType toTimestampType(StringCode target) {
        return convertUtil.toTimestampType(target);
    }
    
    /**
     * <code>DateAndTimeType</code><code>TimestampType</code>ɕϊB
     * <p>
     * imb000000000Őݒ肷B
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static TimestampType toTimestampType(DateAndTimeType target) {
        return convertUtil.toTimestampType(target);
    }
    
    /**
     * <code>DateType</code><code>TimestampType</code>ɕϊB
     * <p>
     * bimb00:00:00:000000000Őݒ肷B
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static TimestampType toTimestampType(DateType target) {
        return convertUtil.toTimestampType(target);
    }
    
    /**
     * <code>StringCode</code><code>TimeType</code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static TimeType toTimeType(StringCode target) {
        return convertUtil.toTimeType(target);
    }
    
    /**
     * <code>DateAndTimeType</code><code>TimeType</code>ɕϊB
     * <p>
     * <code>DateAndTimeType</code>̎b̏ԂB
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static TimeType toTimeType(DateAndTimeType target) {
        return convertUtil.toTimeType(target);
    }
    
    /**
     * <code>TimestampType</code><code>TimeType</code>ɕϊB
     * <p>
     * <code>TimestampType</code>̎b̏ԂB
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public static TimeType toTimeType(TimestampType target) {
        return convertUtil.toTimeType(target);
    }
    
    /**
     * ϊCX^Xݒ肷B
     * @param convertUtilDelegate ϊCX^X
     */
    public static void setFinalunaTypeConvertUtil(FinalunaTypeConvertUtilDelegate convertUtilDelegate) {
        convertUtil = convertUtilDelegate;
    }
}
