/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */

package jp.finaluna.api.type.util;

import jp.finaluna.api.type.ConstantFactory;
import jp.finaluna.api.type.DateAndTimeType;
import jp.finaluna.api.type.DateType;
import jp.finaluna.api.type.DecimalType;
import jp.finaluna.api.type.IntegerType;
import jp.finaluna.api.type.Rcsid;
import jp.finaluna.api.type.TimeType;

/**
 * tñ[eBeBNXB
 * 
 * @version $Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $
 * @author NTTf[^
 */
@Rcsid("$Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $")
public interface DateUtil {

    /**
     * <p>
     * l 1B
     * </p>
     */
    public static final IntegerType D_1 = ConstantFactory.createIntegerType("1");

    /**
     * <p>
     * l 2B
     * </p>
     */
    public static final IntegerType D_2 = ConstantFactory.createIntegerType("2");

    /**
     * <p>
     * l -1B
     * </p>
     */
    public static final IntegerType D_M1 = ConstantFactory.createIntegerType("-1");

    /**
     * <p>
     * l -2B
     * </p>
     */
    public static final IntegerType D_M2 = ConstantFactory.createIntegerType("-2");

    /**
     * <p>
     * l 12B
     * </p>
     */
    public static final IntegerType D_12 = ConstantFactory.createIntegerType("12");

    /**
     * <p>
     * l 15B
     * </p>
     */
    public static final IntegerType D_15 = ConstantFactory.createIntegerType("15");

    /**
     * <p>
     * l 360B
     * </p>
     */
    public static final IntegerType D_360 = ConstantFactory.createIntegerType("360");

    /**
     * <p>
     * l 365B
     * </p>
     */
    public static final IntegerType D_365 = ConstantFactory.createIntegerType("365");

    /**
     * <p>
     * l 366B
     * </p>
     */
    public static final IntegerType D_366 = ConstantFactory.createIntegerType("366");

    /**
     * ttB[h(񋓌^)B
     */
    public enum Calendar {
        /**
         * t\(N)B
         */
        YEAR("YEAR"),
        /**
         * t\()B
         */
        MONTH("MONTH"),
        /**
         * t\()B
         */
        DATE("DATE"),
        /**
         * t\()B
         */
        HOUR("HOUR_OF_DAY"),
        /**
         * t\()B
         */
        MINUTE("MINUTE"),
        /**
         * t\(b)B
         */
        SECOND("SECOND"),
        /**
         * t\(imb)B
         */
        NANO("NANO");

        /**
         * Calendarl
         */
        String value = null;

        /**
         * Calendarlݒ肷B
         * <p>
         * 
         * @param value Calendarl
         */
        Calendar(String value) {
            this.value = value;
        }

        /**
         * Calendarl擾B
         * 
         * @see java.lang.Enum#toString()
         * @return Calendarl
         */
        @Override
        public String toString() {
            return this.value;
        }
    }

    /**
     * j(񋓌^)
     */
    public enum DayOfWeek {
        /**
         * t\ijjB
         */
        SUN("SUNDAY"),
        /**
         * t\ijjB
         */
        MON("MONDAY"),
        /**
         * t\iΗjjB
         */
        TUE("TUESDAY"),
        /**
         * t\ijjB
         */
        WED("WEDNESDAY"),
        /**
         * t\iؗjjB
         */
        THU("THURSDAY"),
        /**
         * t\ijjB
         */
        FRI("FRIDAY"),
        /**
         * t\iyjjB
         */
        SAT("SATURDAY");

        /**
         * DayOfWeekl
         */
        String value = null;

        /**
         * DayOfWeeklݒ肷B
         * <p>
         * 
         * @param value DayOfWeekl
         */
        DayOfWeek(String value) {
            this.value = value;
        }

        /**
         * DayOfWeekl擾B
         * 
         * @see java.lang.Enum#toString()
         * @return Calendarl
         */
        @Override
        public String toString() {
            return this.value;
        }
    }

    /**
     * tvZ [R[h(񋓌^)B
     */
    public enum DayBoundary {
        /**
         * tvZ [R[h [pꍇB
         */
        BOTH("BOTH"),
        /**
         * tvZ [R[h В[ijpꍇB
         */
        START("START"),
        /**
         * tvZ [R[h В[ijpꍇB
         */
        END("END");

        /**
         * DayBoundaryl
         */
        String value = null;

        /**
         * DayBoundarylݒ肷B
         * 
         * @param value DayBoundaryl
         */
        DayBoundary(String value) {
            this.value = value;
        }

        /**
         * DayBoundaryl擾B
         * 
         * @see java.lang.Enum#toString()
         * @return DayBoundaryl
         */
        @Override
        public String toString() {
            return this.value;
        }

        /**
         * Jn܂߂邩肷B
         * 
         * @return Jn܂߂ꍇtrueBłȂfalse
         */
        public boolean includesSTART() {
            return this == BOTH || this == START;
        }

        /**
         * I܂߂邩肷B
         * 
         * @return I܂߂ꍇtrueBłȂfalse
         */
        public boolean includesEND() {
            return this == BOTH || this == END;
        }
    }

    /**
     * j(񋓌^)B
     */
    public enum DayOfWeekInMonth {
        /**
         * Px
         */
        FIRST("FIRST"),
        /**
         * Qx
         */
        SECOND("SECOND"),
        /**
         * Rx
         */
        THIRD("THIRD"),
        /**
         * Sx
         */
        FOURTH("FOURTH"),
        /**
         * ŏI
         */
        LAST("LAST");

        /**
         * DayOfWeekInMonthl
         */
        String value = null;

        /**
         * DayOfWeekInMonthlݒ肷B
         * 
         * @param value j
         */
        DayOfWeekInMonth(String value) {
            this.value = value;
        }

        /**
         * DayOfWeekInMonthl擾B
         * 
         * @return DayOfWeekInMonthl
         */
        @Override
        public String toString() {
            return this.value;
        }
    }

    /**
     * tvZ@(񋓌^)B
     */
    public enum DayCountFraction {
        /**
         * 365vZ
         */
        ACT_365L("ACT_365L"),
        /**
         * vZ
         */
        ACT_ACT_DIVIDED("ACT_ACT_DIVIDED"),
        /**
         * 365ŒvZ
         */
        ACT_365FIXED("ACT_365FIXED"),
        /**
         * 360vZ
         */
        ACT_360("ACT_360"),
        /**
         * 1301N360vZ
         */
        D30_360("D30_360"),
        /**
         * 360vZiI␳̉[lȂj
         */
        D30E_360("D30E_360"),
        /**
         * 360vZiI␳̉[lj
         */
        D360_360("D300_360"),
        /**
         * Actual/365 JGB(NL) {K
         */
        ACT_365JGB_NL("ACT_365JGB_NL");

        /**
         * DayCountFractionl
         */
        String value = null;

        /**
         * DayCountFractionlݒ肷B
         * 
         * @param value tvZ@
         */
        DayCountFraction(String value) {
            this.value = value;
        }

        /**
         * DayCountFractionl擾B
         * 
         * @return DayCountFractionl
         */
        @Override
        public String toString() {
            return this.value;
        }

    }

    /**
     * ԌvZ()
     * 
     * <p>
     * w肵tԂ̓ԂB
     * </p>
     * 
     * @param start Jn
     * @param end I
     * @param boundary El
     * @param fraction tvZ@
     * @return IntegerType 
     */
    IntegerType getDays(DateType start, DateType end, DayBoundary boundary, DayCountFraction fraction);

    /**
     * ԌvZ()
     * 
     * <p>
     * w肵tԂ̎ԂB</br>
     * </p>
     * 
     * @param start Jn
     * @param end I
     * @param boundary El
     * @return IntegerType 
     */
    IntegerType getDays(DateType start, DateType end, DayBoundary boundary);

    /**
     * ԌvZ(N)
     * 
     * <p>
     * w肵t̊(N)ԂB</br>
     * </p>
     * 
     * @param start Jn
     * @param end I
     * @param boundary El
     * @param fraction tvZ@
     * @return DecimalType tԂ̔N
     */
    DecimalType getYears(DateType start, DateType end, DayBoundary boundary, DayCountFraction fraction);

    /**
     * nAYj擾
     * 
     * <p>
     * ̌̑nAYjɑΉt擾B</br>
     * </p>
     * 
     * @param baseDate 
     * @param inMonth j
     * @param week j
     * @return DateType ʓt
     */
    DateType getNthDayByWeekday(DateType baseDate, DayOfWeekInMonth inMonth, DayOfWeek week);

    /**
     * t^擾
     * 
     * <p>
     * t^Ǝ^pēt^쐬B</br> t^̔NtB[hƎ^̎b}[WB
     * </p>
     * 
     * @param date t
     * @param time 
     * @return DateAndTimeType t
     */
    DateAndTimeType getDateTime(DateType date, TimeType time);

}
