/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */

package jp.finaluna.api.type.util;

import jp.finaluna.api.type.DecimalType;
import jp.finaluna.api.type.IntegerType;
import jp.finaluna.api.type.ListType;
import jp.finaluna.api.type.Rcsid;

/**
 * lñ[eBeBB
 * <p>
 * vZs[eBeBNXB
 * </p>
 * <p>
 * 敪lƂĈȉ̋敪ێB<br>
 * <ul>
 * <li>ۂ߃[h敪<br>
 * &nbsp;&nbsp;l̊ۂ߃[h\B
 * <li>͈͋敪<br>
 * &nbsp;&nbsp;El͈̔͂\B
 * <li>El敪<br>
 * &nbsp;&nbsp;El܂ނۂ\B
 * </ul>
 * </p>
 * 
 * @version $Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $
 * @author NTTf[^
 */
@Rcsid("$Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $")
public interface MathUtil {

    /**
     * ۂ߃[h敪(񋓌^)B
     */
    enum Round {
        /**
         * ̖ɋ߂Â悤Ɋۂ߂郂[hB BigDecimal ̏ꍇ ROUND_UP ̂悤ɓ삵A ̏ꍇ ROUND_DOWN ̂悤ɓ삵܂B ̊ۂ߃[h́AvZꂽl炵܂B
         */
        ROUND_CEILING("ROUND_CEILING"),
        /**
         * 0 ɋ߂Â悤Ɋۂ߂郂[hB j鏬ɐs錅𑝕܂ (܂؂̂)B ̊ۂ߃[h́AvZꂽl̐Βl𑝂₵܂B
         */
        ROUND_DOWN("ROUND_DOWN"),
        /**
         * ̖ɋ߂Â悤Ɋۂ߂郂[hB BigDecimal ̏ꍇ ROUND_DOWN ̂悤ɓ삵A ̏ꍇ ROUND_UP ̂悤ɓ삵܂B ̊ۂ߃[h́AvZꂽl𑝂₵܂B
         */
        ROUND_FLOOR("ROUND_FLOOR"),
        /**
         * uƂ߂v Ɋۂ߂郂[hB Aׂ̐̏ꍇ͐؂̂Ă܂B j鏬 .5 𒴂ꍇ ROUND_UP ̂悤ɓ삵A ȊȌꍇ ROUND_DOWN
         * ̂悤ɓ삵܂B
         */
        ROUND_HALF_DOWN("ROUND_HALF_DOWN"),
        /**
         * uƂ߂v Ɋۂ߂郂[hB Aׂ̐̏ꍇ͋Ɋۂ߂܂B j鏬̍ӂ̌̏ꍇ ROUND_HALF_UP ̂悤ɓ삵A ̏ꍇ
         * ROUND_HALF_DOWN ̂悤ɓ삵܂B<br>
         * ̊ۂ߃[h́AAvZŌJԂKpꍇ ݐσG[ŏɂ܂B
         */
        ROUND_HALF_EVEN("ROUND_HALF_EVEN"),
        /**
         * uƂ߂vɊۂ߂郂[hB Aׂ̐̏ꍇ͐؂グ܂B j鏬 .5 ȏ̏ꍇ ROUND_UP ̂悤ɓ삵A ȊȌꍇ ROUND_DOWN
         * ̂悤ɓ삵܂B ͉X̑唼wZŏK؂グ̂ƂłB
         */
        ROUND_HALF_UP("ROUND_HALF_UP"),
        /**
         * v鉉ŽʂmłAۂ߂KvłȂƂ\ۂ߃[hB
         */
        ROUND_UNNECESSARY("ROUND_UNNECESSARY"),
        /**
         * 0 痣悤Ɋۂ߂郂[hB
         */
        ROUND_UP("ROUND_UP");

        /**
         * Roundl
         */
        String value = null;

        /**
         * Roundlݒ肷B
         * <p>
         * 
         * @param value Roundl
         */
        Round(String value) {
            this.value = value;
        }

        /**
         * Roundl擾B
         * 
         * @see java.lang.Enum#toString()
         * @return Roundl
         */
        @Override
        public String toString() {
            return this.value;
        }
    }

    /**
     * ͈͋敪(񋓌^)B
     */
    enum InRange {
        /**
         * E͈̔͏ێlBŏlΏےlőlB
         */
        IN_IN("IN_IN"),
        /**
         * E͈̔͏ێlBŏlΏےlőlB
         */
        IN_EX("IN_EX"),
        /**
         * E͈̔͏ێlBŏlΏےlőlB
         */
        EX_IN("EX_IN"),
        /**
         * E͈̔͏ێlBŏlΏےlőlB
         */
        EX_EX("EX_EX");

        /**
         * InRangel
         */
        String value = null;

        /**
         * InRangelݒ肷B
         * <p>
         * 
         * @param value InRangel
         */
        InRange(String value) {
            this.value = value;
        }

        /**
         * InRangel擾B
         * 
         * @see java.lang.Enum#toString()
         * @return InRangel
         */
        @Override
        public String toString() {
            return this.value;
        }
    }

    /**
     * El敪(񋓌^)B
     */
    enum Boundary {
        /**
         * ElɊ܂ނƂB
         */
        INCLUDE("INCLUDE"),
        /**
         * ElɊ܂܂ȂƂB
         */
        EXCLUDE("EXCLUDE");

        /**
         * Boundaryl
         */
        String value = null;

        /**
         * Boundarylݒ肷B
         * <p>
         * 
         * @param value Boundaryl
         */
        Boundary(String value) {
            this.value = value;
        }

        /**
         * Boundaryl擾B
         * 
         * @see java.lang.Enum#toString()
         * @return Boundaryl
         */
        @Override
        public String toString() {
            return this.value;
        }
    }

    /**
     * <p>
     * <code>DecimalType</code>vB
     * </p>
     * 
     * @param values DecimalTypeXg
     * @return v
     */
    DecimalType sumDecimal(ListType < DecimalType > values);

    /**
     * <p>
     * <code>IntegerType</code>vB
     * </p>
     * 
     * @param values IntegerTypeXg
     * @return v
     */
    IntegerType sumInteger(ListType < IntegerType > values);

    /**
     * <p>
     * <code>DecimalType</code>̕ςZoB
     * ۂ߃[hɂROUND_DOWNgpB
     * </p>
     * 
     * @param values DecimalTypeXg
     * @param scale XP[
     * @return 
     */
    DecimalType averageDecimal(ListType < DecimalType > values, int scale);

    /**
     * <p>
     * <code>DecimalType</code>̕ςZoB
     * </p>
     * 
     * @param values DecimalTypeXg
     * @param scale XP[
     * @param round ۂ߃[h
     * @return 
     */
    DecimalType averageDecimal(ListType < DecimalType > values, int scale, Round round);

    /**
     * <p>
     * <code>IntegerType</code>̕ςZoB
     * ۂ߃[hɂROUND_DOWNgpB
     * </p>
     * 
     * @param values IntegerTypeXg
     * @param scale XP[
     * @return 
     */
    DecimalType averageInteger(ListType < IntegerType > values, int scale);

    /**
     * <p>
     * <code>IntegerType</code>̕ςZoB
     * </p>
     * 
     * @param values IntegerTypeXg
     * @param scale XP[
     * @param round ۂ߃[h
     * @return 
     */
    DecimalType averageInteger(ListType < IntegerType > values, int scale, Round round);
}

