/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */

package jp.finaluna.api.type.util.validator;

import jp.finaluna.api.type.DecimalType;
import jp.finaluna.api.type.IntegerType;
import jp.finaluna.api.type.Rcsid;
import jp.finaluna.api.type.util.MathUtil;

/**
 * <code>IntegerType</code>^y<code>DecimalType</code>^̓̓`FbNs@\B
 * <p>
 * ľ`FbNAl͈̔̓`FbNȂǂsB
 * </p>
 * 
 * @version $Revision: 38309 $ $Date: 2010-03-18 17:14:55 +0900 $
 * @author NTTf[^
 */
@Rcsid("$Revision: 38309 $ $Date: 2010-03-18 17:14:55 +0900 $")
public interface NumericValidator {

    /**
     * <p>
     * IntegerType^͈̔̓`FbNsB
     * <p>
     * <code>range</code>̋Ȅ<br>
     * 
     * <pre>
     *         ŏlΏہől
     * 
     *         ŏlΏہől
     * 
     *         ŏlΏہől
     * 
     *         ŏlΏہől
     * 
     * </pre>
     * 
     * <br>
     * <code>range</code>ɕsȒlݒ肳ĂꍇAFinalunaSysExceptionthrowB
     * <p>
     * 
     * @param value Ώےl
     * @param min ŏl
     * @param max ől
     * @param range Ȅێl<br>
     * @return ΏےlE͈͓ɂꍇA<code>true</code><br>
     *         ΏےlE͈͊OɂꍇA<code>false</code><br>
     *         ΏےlEŏlEőlnull̏ꍇA<code>false</code><br>
     *         ΏےlEŏl  ől̏ꍇA<code>false</code><br>
     */
    boolean isInRange(IntegerType value, IntegerType min, IntegerType max, MathUtil.InRange range);

    /**
     * <p>
     * IntegerType^̍ő包`FbNsB
     * <p>
     * 
     * <code>max</code>0́A̐̏ꍇAFinalunaSysExceptionthrowB
     * 
     * @param value Ώےl
     * @param max ő包
     * @param boundary Ȅێl<br>
     *        INCLUDȄꍇFElɊ܂߂<br>
     *        EXCLUDȄꍇFElɊ܂߂Ȃ<br>
     * @return Ώےl̒ő包菬ꍇA<code>true</code><br>
     *         Ώےl̒ő包傫ꍇA<code>false</code><br>
     *         ΏےlnullłꍇA<code>false</code><br>
     */
    boolean maxLength(IntegerType value, int max, MathUtil.Boundary boundary);

    /**
     * <p>
     * IntgerType^̍ŏ`FbNsB
     * <p>
     * 
     * <code>max</code>0́A̐̏ꍇAFinalunaSysExceptionthrowB
     * 
     * @param value Ώےl
     * @param min ŏ
     * @param boundary Ȅێl<br>
     *        INCLUDȄꍇFElɊ܂߂<br>
     *        EXCLUDȄꍇFElɊ܂߂Ȃ<br>
     * @return Ώےl̒ŏ傫ꍇA<code>true</code><br>
     *         Ώےl̒ŏ菬ꍇA<code>false</code><br>
     *         ΏےlnullłꍇA<code>false</code><br>
     */
    boolean minLength(IntegerType value, int min, MathUtil.Boundary boundary);

    /**
     * <p>
     * DecimalType^͈̔̓`FbNsB
     * <p>
     * <code>range</code>̋Ȅ<br>
     * 
     * <pre>
     *         ŏlΏہől
     * 
     *         ŏlΏہől
     * 
     *         ŏlΏہől
     * 
     *         ŏlΏہől
     * 
     * </pre>
     * 
     * <br>
     * <code>range</code>ɕsȒlݒ肳ĂꍇAFinalunaSysExceptionthrowB
     * <p>
     * 
     * @param value Ώےl
     * @param min ŏl
     * @param max ől
     * @param range Ȅێl<br>
     * @return ΏےlE͈͓ɂꍇA<code>true</code><br>
     *         ΏےlE͈͊OɂꍇA<code>false</code><br>
     *         ΏےlEŏlEőlnull̏ꍇA<code>false</code><br>
     *         ΏےlEŏl  ől̏ꍇA<code>false</code><br>
     */
    boolean isInRange(DecimalType value, DecimalType min, DecimalType max, MathUtil.InRange range);

    /**
     * <p>
     * DecimalType^̍ő包`FbNsB
     * <p>
     * _܂݃`FbNB <code>integerMax</code>܂<code>decimalMax</code> 0́A̐̏ꍇAFinalunaSysExceptionthrowB
     * 
     * @param value Ώےl
     * @param integerMax ő包
     * @param decimalMax ő包
     * @param boundary Ȅێl<br>
     *        INCLUDȄꍇFElɊ܂߂<br>
     *        EXCLUDȄꍇFElɊ܂߂Ȃ<br>
     * @return ΏےľAɍő包菬ꍇA<code>true</code><br>
     *         ΏےľAǂ炩ő包傫ꍇA<code>false</code><br>
     *         ΏےlnullłꍇA<code>false</code><br>
     */
    boolean maxLength(DecimalType value, int integerMax, int decimalMax, MathUtil.Boundary boundary);

    /**
     * <p>
     * DecimalType^̍ŏ`FbNsB
     * <p>
     * _܂݃`FbNB <code>integerMin</code><code>decimalMin</code>0́A ̐̏ꍇAFinalunaSysExceptionthrowB
     * 
     * @param value Ώےl
     * @param integerMin ŏ
     * @param decimalMin ŏ
     * @param boundary Ȅێl<br>
     *        INCLUDȄꍇFElɊ܂߂<br>
     *        EXCLUDȄꍇFElɊ܂߂Ȃ<br>
     * @return ΏےľAɍŏ傫ꍇA<code>true</code><br>
     *         ΏےľAǂ炩ŏ菬ꍇA<code>false</code><br>
     *         ΏےlnullłꍇA<code>false</code><br>
     */
    boolean minLength(DecimalType value, int integerMin, int decimalMin, MathUtil.Boundary boundary);

    /**
     * <p>
     * DecimalType^̍ő包`FbNsB
     * <p>
     * ̂݃`FbNB <code>integerMax</code> 0́A̐̏ꍇAFinalunaSysExceptionthrowB
     * 
     * @param value Ώےl
     * @param integerMax ő包
     * @param boundary Ȅێl<br>
     *        INCLUDȄꍇFElɊ܂߂<br>
     *        EXCLUDȄꍇFElɊ܂߂Ȃ<br>
     * @return Ώےl̐̌ő包菬ꍇA<code>true</code><br>
     *         Ώےl̐̌ő包傫ꍇA<code>false</code><br>
     *         ΏےlnullłꍇA<code>false</code><br>
     */
    boolean maxLength(DecimalType value, int integerMax, MathUtil.Boundary boundary);

    /**
     * <p>
     * DecimalType^̍ŏ`FbNsB
     * <p>
     * ̂݃`FbNB <code>integerMin</code>0́A ̐̏ꍇAFinalunaSysExceptionthrowB
     * 
     * @param value Ώےl
     * @param integerMin ŏ
     * @param boundary Ȅێl<br>
     *        INCLUDȄꍇFElɊ܂߂<br>
     *        EXCLUDȄꍇFElɊ܂߂Ȃ<br>
     * @return Ώےl̐̌ŏ傫ꍇA<code>true</code><br>
     *         Ώےl̐̌ŏ菬ꍇA<code>false</code><br>
     *         ΏےlnullłꍇA<code>false</code><br>
     */
    boolean minLength(DecimalType value, int integerMin, MathUtil.Boundary boundary);
}
