/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */

package jp.finaluna.api.type.util.validator;

import jp.finaluna.api.type.Rcsid;
import jp.finaluna.api.type.StringCode;
import jp.finaluna.api.type.StringType;
import jp.finaluna.api.type.util.MathUtil;

/**
 * <code>StringType</code>^y<code>StringCode</code>^̓̓`FbNs@\B
 * <p>
 * lNULL`FbNAK\ɂ`FbNȂǂsB
 * </p>
 * 
 * @version $Revision: 16647 $ $Date: 2009-02-02 17:26:13 +0900 $
 * @author NTTf[^
 */
@Rcsid("$Revision: 16647 $ $Date: 2009-02-02 17:26:13 +0900 $")
public interface StringValidator {

    /**
     * <p>
     * 󔒁ENULL`FbNsB
     * <p>
     * 
     * @param value Ώےl
     * @return Ώےl󔒁ENULLłꍇA<code>true</code><br>
     *         Ώےl󔒁ENULLłȂꍇA<code>false</code><br>
     */
    boolean isBlankOrNull(StringType value);

    /**
     * <p>
     * 󔒁ENULL`FbNsB
     * <p>
     * 
     * @param value Ώےl
     * @return Ώےl󔒁ENULLłꍇA<code>true</code><br>
     *         Ώےl󔒁ENULLłȂꍇA<code>false</code><br>
     */
    boolean isBlankOrNull(StringCode value);

    /**
     * <p>
     * l`FbNsB
     * <p>
     * 
     * @param value Ώےl
     * @return ΏےlIntegerType^ɕϊłꍇA<code>true</code><br>
     *         ΏےlIntegerType^ɕϊłȂꍇA<code>false</code><br>
     *         ΏےlnullłꍇA<code>false</code><br>
     */
    boolean isInteger(StringType value);

    /**
     * <p>
     * l`FbNsB
     * <p>
     * 
     * @param value Ώےl
     * @return ΏےlIntegerType^ɕϊłꍇA<code>true</code><br>
     *         ΏےlIntegerType^ɕϊłȂꍇA<code>false</code><br>
     *         ΏےlnullłꍇA<code>false</code><br>
     */
    boolean isInteger(StringCode value);

    /**
     * <p>
     * `FbNsB
     * <p>
     * 
     * @param value Ώےl
     * @return ΏےlDecimalType^ɕϊłꍇA<code>true</code><br>
     *         ΏےlDecimalType^ɕϊłȂꍇA<code>false</code><br>
     *         ΏےlnullłꍇA<code>false</code><br>
     */
    boolean isDecimal(StringType value);

    /**
     * <p>
     * `FbNsB
     * <p>
     * 
     * @param value Ώےl
     * @return ΏےlDecimalType^ɕϊłꍇA<code>true</code><br>
     *         ΏےlDecimalType^ɕϊłȂꍇA<code>false</code><br>
     *         ΏےlnullłꍇA<code>false</code><br>
     */
    boolean isDecimal(StringCode value);

    /**
     * <p>
     * K\`FbNsB
     * <p>
     * 
     * @param value Ώےl
     * @param regexp K\
     * @return ΏےlK\ƈvĂꍇA<code>true</code><br>
     *         ΏےlK\ƈvĂȂꍇA<code>false</code><br>
     *         ΏےlEK\nullłꍇA<code>false</code><br>
     */
    boolean matchRegexp(StringType value, StringType regexp);

    /**
     * <p>
     * K\`FbNsB
     * <p>
     * 
     * @param value Ώےl
     * @param regexp K\
     * @return ΏےlK\ƈvĂꍇA<code>true</code><br>
     *         ΏےlK\ƈvĂȂꍇA<code>false</code><br>
     *         ΏےlEK\nullłꍇA<code>false</code><br>
     */
    boolean matchRegexp(StringCode value, StringCode regexp);

    /**
     * <p>
     * StringType^̍ő啶`FbNsB
     * <p>
     * 
     * <code>max</code>0́A̐̏ꍇAFinalunaSysExceptionthrowB
     * 
     * @param value Ώےl
     * @param max ő啶
     * @param boundary Ȅێl<br>
     *        INCLUDȄꍇFElɊ܂߂<br>
     *        EXCLUDȄꍇFElɊ܂߂Ȃ<br>
     * @return Ώےl̕ő啶菬ꍇA<code>true</code><br>
     *         Ώےl̕ő啶傫ꍇA<code>false</code><br>
     *         ΏےlnullłꍇA<code>false</code><br>
     */
    boolean maxLength(StringType value, int max, MathUtil.Boundary boundary);

    /**
     * <p>
     * StringCode^̍ő啶`FbNsB
     * <p>
     * 
     * <code>max</code>0́A̐̏ꍇAFinalunaSysExceptionthrowB
     * 
     * @param value Ώےl
     * @param max ő啶
     * @param boundary Ȅێl<br>
     *        INCLUDȄꍇFElɊ܂߂<br>
     *        EXCLUDȄꍇFElɊ܂߂Ȃ<br>
     * @return Ώےl̕ő啶菬ꍇA<code>true</code><br>
     *         Ώےl̕ő啶傫ꍇA<code>false</code><br>
     *         ΏےlnullłꍇA<code>false</code><br>
     */
    boolean maxLength(StringCode value, int max, MathUtil.Boundary boundary);

    /**
     * <p>
     * StringType^̍ŏ`FbNsB
     * <p>
     * 
     * <code>max</code>0́A̐̏ꍇAFinalunaSysExceptionthrowB
     * 
     * @param value Ώےl
     * @param min ŏ
     * @param boundary Ȅێl<br>
     *        INCLUDȄꍇFElɊ܂߂<br>
     *        EXCLUDȄꍇFElɊ܂߂Ȃ<br>
     * @return Ώےl̕ŏ傫ꍇA<code>true</code><br>
     *         Ώےl̕ŏ菬ꍇA<code>false</code><br>
     *         ΏےlnullłꍇA<code>false</code><br>
     */
    boolean minLength(StringType value, int min, MathUtil.Boundary boundary);

    /**
     * <p>
     * StringCode^̍ŏ`FbNsB
     * <p>
     * 
     * <code>max</code>0́A̐̏ꍇAFinalunaSysExceptionthrowB
     * 
     * @param value Ώےl
     * @param min ŏ
     * @param boundary Ȅێl<br>
     *        INCLUDȄꍇFElɊ܂߂<br>
     *        EXCLUDȄꍇFElɊ܂߂Ȃ<br>
     * @return Ώےl̕ŏ傫ꍇA<code>true</code><br>
     *         Ώےl̕ŏ菬ꍇA<code>false</code><br>
     *         ΏےlnullłꍇA<code>false</code><br>
     */
    boolean minLength(StringCode value, int min, MathUtil.Boundary boundary);
}
