/**
    fixw - a simple win32 program for fix window position and size.
    Copyright (C) 2009  yamada tarou

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**/

#include <windows.h>

/** for do not have unicode function **/
#ifndef	_T
#define	_T(x)	x
#endif
#ifndef	TEXT
#define	TEXT(x)	_T(x)
#endif
#ifndef	_tWinMain
#define	_tWinMain(x, y, z, w)	WinMain(x, y, z, w)
#endif
#ifndef	_ttoi
#define	_ttoi(x)	atoi(x)
#endif
#ifndef	_tcscmp
#define	_tcscmp(x, y)	strcmp(x, y)
#endif
#ifndef	_tcscpy
#define	_tcscpy(x, y)	strcpy(x, y)
#endif


/** app info **/
#define	APP_NAME	_T("fixw")
#define	APP_VERSION	_T("0.1.1")


/** locale **/
#ifdef	LANG_C	/** en_US **/
#define	TXT_POSITION	_T("Position")
#define	TXT_SIZE	_T("Size")
#define	TXT_TOPLEFT	_T("Top &Left")
#define	TXT_TOPRIGHT	_T("Top &Right")
#define	TXT_BOTTOMLEFT	_T("Bottom L&eft")
#define	TXT_BOTTOMRIGHT	_T("&Bottom Right")
#define	TXT_CENTER	_T("&Center")
#define	TXT_VERTICALHALF	_T("&Vertical")
#define	TXT_HORIZONTALHALF	_T("&Horizontal")
#define	TXT_QUARTER	_T("&Quarter")
#define	TXT_SPECIFIC	_T("&Specified")
#define	TXT_REFRESH	_T("Re&fresh")
#define	TXT_APPLY	_T("&Apply")
#define	TXT_LABEL	_T("x")
#define	TXT_ABOUT	_T("&About ") APP_NAME _T("...")
#define	TXT_ABOUTTITLE	_T("About ") APP_NAME
#define	TXT_LLABEL	_T("L&ist")
#define	TXT_NOPOS	_T("&None")
#define	TXT_NOSIZE	_T("N&one")

#define	WDT_BUTTON	52
#define	WDT_POSRADIO	92
#define	WDT_SIZRADIO	70
#define	WDT_SIZEDIT	106

#define	WDT_EDIT	36
#define	WDT_LABEL	8
#define	WDT_LLABEL	52
#else	/** localize **/
#define	TXT_POSITION	_T("ʒu")
#define	TXT_SIZE	_T("傫")
#define	TXT_TOPLEFT	_T("(&L)")
#define	TXT_TOPRIGHT	_T("E(&R)")
#define	TXT_BOTTOMLEFT	_T("(&E)")
#define	TXT_BOTTOMRIGHT	_T("E(&B)")
#define	TXT_CENTER	_T("(&C)")
#define	TXT_VERTICALHALF	_T("c(&V)")
#define	TXT_HORIZONTALHALF	_T("(&H)")
#define	TXT_QUARTER	_T("l(&Q)")
#define	TXT_SPECIFIC	_T("w(&S)")
#define	TXT_REFRESH	_T("XV(&F)")
#define	TXT_APPLY	_T("Kp(&A)")
#define	TXT_LABEL	_T("x")
#define	TXT_ABOUT	APP_NAME _T("ɂ(&A)...")
#define	TXT_ABOUTTITLE	APP_NAME _T("ɂ")
#define	TXT_LLABEL	_T("ꗗ(&I)")
#define	TXT_NOPOS	_T("Ȃ(&N)")
#define	TXT_NOSIZE	_T("Ȃ(&O)")

#define	WDT_BUTTON	52
#define	WDT_POSRADIO	66
#define	WDT_SIZRADIO	80
#define	WDT_SIZEDIT	106

#define	WDT_EDIT	36
#define	WDT_LABEL	8
#define	WDT_LLABEL	52
#endif	/** /locale **/


/** control positoin and size **/
#define	HGT_RADIO	26
#define	VPD_GROUP	16
#define	HPD_GROUP	10
#define	HPD_CONTROL	5
#define	VPD_CONTROL	5

#define	HGT_BUTTON	24

#define	WDT_SPECIFIC	8
#define	HGT_EDIT	20
#define	HGT_LABEL	20
#define	HGT_LLABEL	14
#define	TOP_LIST	102 + VPD_CONTROL

#define	LFT_REFRESH	HPD_CONTROL
#define	TOP_REFRESH	6 + VPD_CONTROL

#define	LFT_APPLY	HPD_CONTROL
#define	TOP_APPLY	TOP_REFRESH + HGT_BUTTON + VPD_CONTROL

#define	WDT_POSITION	HPD_GROUP + (WDT_POSRADIO * 2) + HPD_CONTROL
#define	HGT_POSITION	VPD_GROUP + (HGT_RADIO * 3) + VPD_CONTROL
#define	LFT_POSITION	LFT_APPLY + WDT_BUTTON + HPD_CONTROL
#define	TOP_POSITION	VPD_CONTROL

#define	WDT_SIZE	HPD_GROUP + (WDT_SIZRADIO + WDT_SIZEDIT) + HPD_CONTROL
#define	HGT_SIZE	VPD_GROUP + (HGT_RADIO * 3) + VPD_CONTROL
#define	LFT_SIZE	LFT_POSITION + WDT_POSITION + HPD_CONTROL
#define	TOP_SIZE	VPD_CONTROL

#define	LFT_TOPLEFT	HPD_GROUP
#define	TOP_TOPLEFT	VPD_GROUP

#define	LFT_TOPRIGHT	HPD_GROUP + WDT_POSRADIO
#define	TOP_TOPRIGHT	VPD_GROUP

#define	LFT_BOTTOMLEFT	HPD_GROUP
#define	TOP_BOTTOMLEFT	VPD_GROUP + HGT_RADIO

#define	LFT_BOTTOMRIGHT	HPD_GROUP + WDT_POSRADIO
#define	TOP_BOTTOMRIGHT	VPD_GROUP + HGT_RADIO

#define	LFT_CENTER	HPD_GROUP
#define	TOP_CENTER	VPD_GROUP + (HGT_RADIO * 2)

#define	LFT_NOPOS	LFT_CENTER + WDT_POSRADIO
#define	TOP_NOPOS	VPD_GROUP + (HGT_RADIO * 2)

#define	LFT_VERTICALHALF	HPD_GROUP
#define	TOP_VERTICALHALF	VPD_GROUP

#define	LFT_HORIZONTALHALF	HPD_GROUP + WDT_SIZRADIO
#define	TOP_HORIZONTALHALF	VPD_GROUP

#define	LFT_QUARTER	HPD_GROUP
#define	TOP_QUARTER	VPD_GROUP + HGT_RADIO

#define	LFT_NOSIZE	HPD_GROUP
#define	TOP_NOSIZE	VPD_GROUP + (HGT_RADIO * 2)

#define	LFT_SPECIFIC	HPD_GROUP + WDT_SIZRADIO
#define	TOP_SPECIFIC	VPD_GROUP + HGT_RADIO

#define	LFT_WIDTH	LFT_SPECIFIC + WDT_SPECIFIC + HPD_CONTROL
#define	TOP_WIDTH	TOP_SPECIFIC + HGT_RADIO + 3

#define	LFT_LABEL	LFT_WIDTH + WDT_EDIT + HPD_CONTROL
#define	TOP_LABEL	TOP_SPECIFIC + HGT_RADIO + 6

#define	LFT_HEIGHT	LFT_LABEL + WDT_LABEL + HPD_CONTROL
#define	TOP_HEIGHT	TOP_SPECIFIC + HGT_RADIO + 3

#define	LFT_LLABEL	HPD_CONTROL
#define	TOP_LLABEL	(TOP_POSITION + HGT_POSITION) - HGT_LLABEL


#define	WDT_WINDOW	LFT_SIZE + WDT_SIZE + HPD_CONTROL
#define	HGT_WINDOW	TOP_LIST + HGT_RADIO


/** windows message **/
#define	WM_TASKTRAY	WM_APP + 1
#ifndef	WM_SYSTEMMENU
#define	WM_SYSTEMMENU	0x0313
#endif


enum	{	/** IDs **/
	IDC_LIST = 1
,	IDC_TOPLEFT
,	IDC_TOPRIGHT
,	IDC_BOTTOMLEFT
,	IDC_BOTTOMRIGHT
,	IDC_CENTER
,	IDC_NOPOS
,	IDC_VERTICALHALF
,	IDC_HORIZONTALHALF
,	IDC_QUARTER
,	IDC_APPLYBUTTON
,	IDC_REFRESHBUTTON
,	IDC_SPECIFIC
,	IDC_NOSIZE
,	IDC_LABEL
,	IDC_LLABEL
,	IDC_WIDTH
,	IDC_HEIGHT
,	IDM_ABOUT
};

static HWND	/** child controles **/
	lst = 0
,	gpp = 0
,	gps = 0
,	bta = 0
,	btr = 0
,	ptl = 0
,	ptr = 0
,	pbl = 0
,	pbr = 0
,	pct = 0
,	pnp = 0
,	svh = 0
,	shh = 0
,	sft = 0
,	sns = 0
,	sav = 0
,	lbl = 0
,	lbr = 0
,	ewd = 0
,	eht = 0
;

static WNDPROC	/** for groupboxes subclassing **/
	gppWndProc = NULL
,	gpsWndProc = NULL
;

static	RECT	oldRct;	/** **/

#define	isChecked(x)	((int)SendMessage(x, BM_GETCHECK, 0, 0) == BST_CHECKED)
#ifndef	SetWindowFont
#define	SetWindowFont(x, y, z)	(SendMessage(x, WM_SETFONT, (WPARAM)y, MAKELPARAM(FALSE, 0)))
#endif

BOOL CALLBACK	activateWindows(HWND hwd, LPARAM prm)	{
	TCHAR	bfr[MAX_PATH];
	if	(!IsWindowVisible(hwd) || !GetWindowText(hwd, bfr, MAX_PATH) || _tcscmp((PTCHAR)prm, bfr))	{	return	TRUE;	}	/** not found **/
	ShowWindow(hwd, SW_SHOW);
	SetForegroundWindow(hwd);
	return	FALSE;
}
BOOL CALLBACK	listWindows(HWND hwd, LPARAM prm)	{
	TCHAR	bfr[MAX_PATH];
	if	(!IsWindowVisible(hwd) || !GetWindowText(hwd, bfr, MAX_PATH))	{	return	TRUE;	}	/** ignore non-visible or empty title **/
	SendMessage((HWND)prm, LB_ADDSTRING, 0, (LPARAM)bfr);	/** append list **/
	return	TRUE;
}

BOOL CALLBACK	fixWindows(HWND hwd, LPARAM prm)	{
	TCHAR	bfr[MAX_PATH], wdt[11], hgt[11];
	RECT	rct, lct;
	int	wdv, hgv, lcw, lch, rcw, rch;
	if	(!IsWindowVisible(hwd) || !GetWindowText(hwd, bfr, MAX_PATH) || _tcscmp((PTCHAR)prm, bfr))	{	return	TRUE;	}	/** not found **/
	SystemParametersInfo(SPI_GETWORKAREA, 0, &rct, 0);
	GetWindowRect(hwd, &lct);
	rcw = rct.right - rct.left;
	rch = rct.bottom - rct.top;
	
	/** adjust window size **/
	if	(isChecked(svh))	{
		lcw = rcw / 2;
		lch = rch;
	}	else if	(isChecked(shh))	{
		lcw = rcw;
		lch = rch / 2;
	}	else if	(isChecked(sft))	{
		lcw = rcw / 2;
		lch = rch / 2;
	}	else if	(isChecked(sav))	{
		if	(
			!GetWindowText(ewd, wdt, 11) || !GetWindowText(eht, hgt, 11)
		||	(wdv = _ttoi(wdt)) <= 0 || (hgv = _ttoi(hgt)) <= 0
		)	{
			return	TRUE;
		}
		lcw = wdv;
		lch = hgv;
	}	else	{
		lcw = lct.right - lct.left;
		lch = lct.bottom - lct.top;
	}
	
	/** adjust window position **/
	if	(isChecked(ptl))	{
		lct.top = rct.top;
		lct.left = rct.left;
	}	else if	(isChecked(ptr))	{
		lct.top = rct.top;
		lct.left = rct.right - lcw;
	}	else if	(isChecked(pbl))	{
		lct.top = rct.bottom - lch;
		lct.left = rct.left;
	}	else if	(isChecked(pbr))	{
		lct.top = rct.bottom - lch;
		lct.left = rct.right - lcw;
	}	else if	(isChecked(pct))	{
		lct.top = rct.top + ((rch - lch) / 2);
		lct.left = rct.left + ((rcw - lcw) / 2);
	}
	
	/** fix **/
	if	(IsIconic(hwd))	{	ShowWindow(hwd, SW_RESTORE);	}
	MoveWindow(hwd, lct.left, lct.top, lcw, lch, TRUE);
	return	FALSE;
}

static void	refresh()	{
	SendMessage(lst, WM_SETREDRAW, (WPARAM)FALSE, 0);
	SendMessage(lst, LB_RESETCONTENT, 0, 0);
	EnumWindows(listWindows, (LPARAM)lst);
	SendMessage(lst, LB_SETCURSEL, 0, 0);
	SendMessage(lst, WM_SETREDRAW, (WPARAM)TRUE, 0);
}

static LRESULT	onSize(HWND hwd, WPARAM state)	{
	RECT	rct;
	GetClientRect(hwd, &rct);
	MoveWindow(lst, 0, TOP_LIST, rct.right, rct.bottom - TOP_LIST - 10, TRUE);
	return	0;
}

static LRESULT	onDestroy(HWND hwd)	{
	PostQuitMessage(0);
	return	0;
}

static LRESULT	onApply(HWND hwd)	{
	TCHAR	bfr[MAX_PATH];
	LONG	cursel = SendMessage(lst, LB_GETCURSEL, 0, 0);
	if	(cursel == LB_ERR)	{	return	0;	}	/** ignore empty title **/
	SendMessage(lst, LB_GETTEXT, cursel, (LPARAM)bfr);
	EnumWindows(fixWindows, (LPARAM)bfr);
	return	0;
}

static LRESULT	onRefresh(HWND hwd)	{
	refresh();
	return	0;
}

static LRESULT	onListDblClick(HWND hwd)	{
	TCHAR	bfr[MAX_PATH];
	LONG	cursel = SendMessage(lst, LB_GETCURSEL, 0, 0);
	if	(cursel == LB_ERR)	{	return	0;	}	/** ignore empty title **/
	SendMessage(lst, LB_GETTEXT, cursel, (LPARAM)bfr);
	EnumWindows(activateWindows, (LPARAM)bfr);
	return	0;
}

static LRESULT	onAbout(HWND hwd)	{
	MessageBox(hwd, APP_NAME _T("\r\n\r\nVersion ") APP_VERSION, TXT_ABOUTTITLE, MB_ICONINFORMATION | MB_OK);
	return	0;
}

static LRESULT	onCommand(HWND hwd, WORD notifyCode, WORD id, HWND cwd)	{
	switch	(id)	{
	case	IDC_APPLYBUTTON:
		return	onApply(cwd);
	case	IDC_REFRESHBUTTON:
		return	onRefresh(cwd);
	case	IDC_LIST:
		if	(notifyCode == LBN_DBLCLK)	{
			return	onListDblClick(cwd);
		}
		break;
	case	IDC_VERTICALHALF:
	case	IDC_HORIZONTALHALF:
	case	IDC_QUARTER:
	case	IDC_NOSIZE:
		SendMessage(ewd, EM_SETREADONLY, 1, 0);
		SendMessage(eht, EM_SETREADONLY, 1, 0);
		break;
	case	IDC_SPECIFIC:
		SendMessage(ewd, EM_SETREADONLY, 0, 0);
		SendMessage(eht, EM_SETREADONLY, 0, 0);
		break;
	default:
		break;
	}
	return	0;
}

static LRESULT	onTaskTray(HWND hwd, LPARAM msg)	{
	POINT	mpt;
	switch	(msg)	{
	case	WM_RBUTTONUP:
		/** show system menu **/
		GetCursorPos(&mpt);
		SendMessage(hwd, WM_SYSTEMMENU, 0, mpt.x | mpt.y * 0x10000);
		break;
	case	WM_LBUTTONUP:
		/** toggle icon display **/
		if	(!IsWindowVisible(hwd))	{
			refresh();
			ShowWindow(hwd, SW_RESTORE);
			MoveWindow(hwd, oldRct.left, oldRct.top, oldRct.right - oldRct.left, oldRct.bottom - oldRct.top, TRUE);
			SetForegroundWindow(hwd);
		}	else	{
			GetWindowRect(hwd, &oldRct);
			ShowWindow(hwd, SW_MINIMIZE);
			ShowWindow(hwd, SW_HIDE);
		}
		break;
	default:
		break;
	}
	return	0;
}

static LRESULT	onGetMinMaxInfo(HWND hwd, LPMINMAXINFO pmi)	{
	RECT	crt, wrt;
	GetClientRect(hwd, &crt);
	GetWindowRect(hwd, &wrt);
	pmi->ptMinTrackSize.x = WDT_WINDOW + ((wrt.right - wrt.left) - crt.right);
	pmi->ptMinTrackSize.y = HGT_WINDOW + ((wrt.bottom - wrt.top) - crt.bottom);
	return	0;
}

LRESULT CALLBACK	onGroupWndProc(HWND hwd, UINT msg, WPARAM wpm, LPARAM lpm)	{
	RECT	rct;
	switch	(msg)	{
	case	WM_COMMAND:
		return	onCommand(hwd, HIWORD(wpm), LOWORD(wpm), (HWND)lpm);
	case	WM_ERASEBKGND:	/** for xp visual style **/
		GetClientRect(hwd, &rct);
		FillRect((HDC)wpm, &rct, (HBRUSH)(COLOR_3DFACE + 1));
		return	0;
	default:
		return	CallWindowProc(hwd == gpp ? gppWndProc : gpsWndProc, hwd, msg, wpm, lpm);
	}
}

static LRESULT	onCreate(HWND hwd, LPCREATESTRUCT pcs)	{
	MENUITEMINFO	mii;
	HFONT	hft;
	HMENU	hsm = GetSystemMenu(hwd, FALSE);
	
	/** insert about menu to system menu **/
	mii.cbSize = sizeof(mii);
	mii.fMask = MIIM_ID | MIIM_TYPE;
	mii.wID = IDM_ABOUT;
	mii.dwTypeData = TXT_ABOUT;
	mii.fType = MFT_SEPARATOR;
	InsertMenuItem(hsm, 5, TRUE, &mii);
	mii.fType = MFT_STRING;
	InsertMenuItem(hsm, 6, TRUE, &mii);
	
	/** create child controles **/
	GetWindowRect(hwd, &oldRct);
	hft = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SetWindowFont(hwd, hft, FALSE);
	btr = CreateWindowEx(0, _T("BUTTON"), TXT_REFRESH, WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON | WS_TABSTOP
	,	LFT_REFRESH, TOP_REFRESH, WDT_BUTTON, HGT_BUTTON, hwd, (HMENU)IDC_REFRESHBUTTON, pcs->hInstance, NULL
	);
	SetWindowFont(btr, hft, FALSE);
	bta = CreateWindowEx(0, _T("BUTTON"), TXT_APPLY, WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON | WS_TABSTOP
	,	LFT_APPLY, TOP_APPLY, WDT_BUTTON, HGT_BUTTON, hwd, (HMENU)IDC_APPLYBUTTON, pcs->hInstance, NULL
	);
	SetWindowFont(bta, hft, FALSE);
	lbr = CreateWindowEx(0, _T("STATIC"), TXT_LLABEL, WS_CHILD | WS_VISIBLE | SS_LEFT | WS_TABSTOP
	,	LFT_LLABEL, TOP_LLABEL, WDT_LLABEL, HGT_LLABEL, hwd, (HMENU)IDC_LLABEL, pcs->hInstance, NULL
	);
	SetWindowFont(lbr, hft, FALSE);
	lst = CreateWindowEx(WS_EX_CLIENTEDGE, _T("LISTBOX"), _T(""), WS_CHILD | WS_VISIBLE | LBS_STANDARD | LBS_NOINTEGRALHEIGHT | WS_TABSTOP
	,	0, 0, 10, 10, hwd, (HMENU)IDC_LIST, pcs->hInstance, NULL
	);
	SetWindowFont(lst, hft, FALSE);
	gpp = CreateWindowEx(WS_EX_CONTROLPARENT, _T("BUTTON"), TXT_POSITION, WS_CHILD | WS_VISIBLE | BS_GROUPBOX
		,	LFT_POSITION, TOP_POSITION, WDT_POSITION, HGT_POSITION, hwd, NULL, pcs->hInstance, NULL
	);
	SetWindowFont(gpp, hft, FALSE);
	gps = CreateWindowEx(WS_EX_CONTROLPARENT, _T("BUTTON"), TXT_SIZE, WS_CHILD | WS_VISIBLE | BS_GROUPBOX
	,	LFT_SIZE, TOP_SIZE, WDT_SIZE, HGT_SIZE, hwd, NULL, pcs->hInstance, NULL
	);
	SetWindowFont(gps, hft, FALSE);
	ptl = CreateWindowEx(0, _T("BUTTON"), TXT_TOPLEFT, WS_CHILD | WS_VISIBLE | WS_GROUP | BS_AUTORADIOBUTTON | WS_TABSTOP
	,	LFT_TOPLEFT, TOP_TOPLEFT, WDT_POSRADIO, HGT_RADIO, gpp, (HMENU)IDC_TOPLEFT, pcs->hInstance, NULL
	);
	SetWindowFont(ptl, hft, FALSE);
	ptr = CreateWindowEx(0, _T("BUTTON"), TXT_TOPRIGHT, WS_CHILD | WS_VISIBLE | BS_AUTORADIOBUTTON | WS_TABSTOP
	,	LFT_TOPRIGHT, TOP_TOPRIGHT, WDT_POSRADIO, HGT_RADIO, gpp, (HMENU)IDC_TOPRIGHT, pcs->hInstance, NULL
	);
	SetWindowFont(ptr, hft, FALSE);
	pbl = CreateWindowEx(0, _T("BUTTON"), TXT_BOTTOMLEFT, WS_CHILD | WS_VISIBLE | BS_AUTORADIOBUTTON | WS_TABSTOP
	,	LFT_BOTTOMLEFT, TOP_BOTTOMRIGHT, WDT_POSRADIO, HGT_RADIO, gpp, (HMENU)IDC_BOTTOMLEFT, pcs->hInstance, NULL
	);
	SetWindowFont(pbl, hft, FALSE);
	pbr = CreateWindowEx(0, _T("BUTTON"), TXT_BOTTOMRIGHT, WS_CHILD | WS_VISIBLE | BS_AUTORADIOBUTTON | WS_TABSTOP
	,	LFT_BOTTOMRIGHT, TOP_BOTTOMRIGHT, WDT_POSRADIO, HGT_RADIO, gpp, (HMENU)IDC_BOTTOMRIGHT, pcs->hInstance, NULL
	);
	SetWindowFont(pbr, hft, FALSE);
	pct = CreateWindowEx(0, _T("BUTTON"), TXT_CENTER, WS_CHILD | WS_VISIBLE | BS_AUTORADIOBUTTON | WS_TABSTOP
	,	LFT_CENTER, TOP_CENTER, WDT_POSRADIO, HGT_RADIO, gpp, (HMENU)IDC_CENTER, pcs->hInstance, NULL
	);
	SetWindowFont(pct, hft, FALSE);
	pnp = CreateWindowEx(0, _T("BUTTON"), TXT_NOPOS, WS_CHILD | WS_VISIBLE | BS_AUTORADIOBUTTON | WS_TABSTOP
	,	LFT_NOPOS, TOP_NOPOS, WDT_POSRADIO, HGT_RADIO, gpp, (HMENU)IDC_NOPOS, pcs->hInstance, NULL
	);
	SetWindowFont(pnp, hft, FALSE);
	svh = CreateWindowEx(0, _T("BUTTON"), TXT_VERTICALHALF, WS_CHILD | WS_VISIBLE | WS_GROUP | BS_AUTORADIOBUTTON | WS_TABSTOP
	,	LFT_VERTICALHALF, TOP_VERTICALHALF, WDT_SIZRADIO, HGT_RADIO, gps, (HMENU)IDC_VERTICALHALF, pcs->hInstance, NULL
	);
	SetWindowFont(svh, hft, FALSE);
	shh = CreateWindowEx(0, _T("BUTTON"), TXT_HORIZONTALHALF, WS_CHILD | WS_VISIBLE | BS_AUTORADIOBUTTON | WS_TABSTOP
	,	LFT_HORIZONTALHALF, TOP_HORIZONTALHALF, WDT_SIZRADIO, HGT_RADIO, gps, (HMENU)IDC_HORIZONTALHALF, pcs->hInstance, NULL
	);
	SetWindowFont(shh, hft, FALSE);
	sft = CreateWindowEx(0, _T("BUTTON"), TXT_QUARTER, WS_CHILD | WS_VISIBLE | BS_AUTORADIOBUTTON | WS_TABSTOP
	,	LFT_QUARTER, TOP_QUARTER, WDT_SIZRADIO, HGT_RADIO, gps, (HMENU)IDC_QUARTER, pcs->hInstance, NULL
	);
	SetWindowFont(sft, hft, FALSE);
	sns = CreateWindowEx(0, _T("BUTTON"), TXT_NOSIZE, WS_CHILD | WS_VISIBLE | BS_AUTORADIOBUTTON | WS_TABSTOP
	,	LFT_NOSIZE, TOP_NOSIZE, WDT_SIZRADIO, HGT_RADIO, gps, (HMENU)IDC_NOSIZE, pcs->hInstance, NULL
	);
	SetWindowFont(sns, hft, FALSE);
	lbl = CreateWindowEx(0, _T("STATIC"), TXT_LABEL, WS_CHILD | WS_VISIBLE | SS_CENTER
	,	LFT_LABEL, TOP_LABEL, WDT_LABEL, HGT_LABEL, gps, (HMENU)IDC_LABEL, pcs->hInstance, NULL
	);
	SetWindowFont(lbl, hft, FALSE);
	sav = CreateWindowEx(0, _T("BUTTON"), TXT_SPECIFIC, WS_CHILD | WS_VISIBLE | BS_AUTORADIOBUTTON | WS_TABSTOP
	,	LFT_SPECIFIC, TOP_SPECIFIC, WDT_SIZRADIO, HGT_RADIO, gps, (HMENU)IDC_SPECIFIC, pcs->hInstance, NULL
	);
	SetWindowFont(sav, hft, FALSE);
	ewd = CreateWindowEx(WS_EX_CLIENTEDGE, _T("EDIT"), NULL, WS_CHILD | WS_VISIBLE | WS_BORDER | ES_NUMBER | ES_RIGHT | WS_TABSTOP
	,	LFT_WIDTH, TOP_WIDTH, WDT_EDIT, HGT_EDIT, gps, (HMENU)IDC_WIDTH, pcs->hInstance, NULL
	);
	SetWindowFont(ewd, hft, FALSE);
	eht = CreateWindowEx(WS_EX_CLIENTEDGE, _T("EDIT"), NULL, WS_CHILD | WS_VISIBLE | WS_BORDER | ES_NUMBER | ES_RIGHT | WS_TABSTOP
	,	LFT_HEIGHT, TOP_HEIGHT, WDT_EDIT, HGT_EDIT, gps, (HMENU)IDC_HEIGHT, pcs->hInstance, NULL
	);
	SetWindowFont(eht, hft, FALSE);
	
	/** groupboxes subclassing **/
	gppWndProc = (WNDPROC)GetWindowLong(gpp, GWL_WNDPROC);
	SetWindowLong(gpp, GWL_WNDPROC, (LONG)onGroupWndProc);
	gpsWndProc = (WNDPROC)GetWindowLong(gps, GWL_WNDPROC);
	SetWindowLong(gps, GWL_WNDPROC, (LONG)onGroupWndProc);
	refresh();
	SetFocus(lst);
	
	/** set default check **/
	SendMessage(ptl, BM_SETCHECK, 1, 0);
	SendMessage(svh, BM_SETCHECK, 1, 0);
	SendMessage(ewd, EM_SETREADONLY, 1, 0);
	SendMessage(eht, EM_SETREADONLY, 1, 0);
	return	0;
}

LRESULT CALLBACK	windowProc(HWND hwd, UINT msg, WPARAM wpm, LPARAM lpm)	{
	switch	(msg)	{
	case	WM_CREATE:
		return	onCreate(hwd, (LPCREATESTRUCT)lpm);
	case	WM_SIZE:
		return	onSize(hwd, wpm);
	case	WM_DESTROY:
		return	onDestroy(hwd);
	case	WM_COMMAND:
		return	onCommand(hwd, HIWORD(wpm), LOWORD(wpm), (HWND)lpm);
	case	WM_TASKTRAY:
		return	onTaskTray(hwd, lpm);
	case	WM_SYSCOMMAND:
		if	(wpm == SC_MINIMIZE)	{
			GetWindowRect(hwd, &oldRct);
			ShowWindow(hwd, SW_MINIMIZE);
			ShowWindow(hwd, SW_HIDE);
			return	0;	/** ignore default process **/
		}	else if	(LOWORD(wpm) == IDM_ABOUT)	{
			return	onAbout(hwd);
		}
		break;
	case	WM_GETMINMAXINFO:
		return	onGetMinMaxInfo(hwd, (LPMINMAXINFO)lpm);
	default:
		break;
	}
	return	DefWindowProc(hwd, msg, wpm, lpm);
}

LRESULT CALLBACK	dummyWndProc(HWND hwd, UINT msg, WPARAM wpm, LPARAM lpm)	{
	return	DefWindowProc(hwd, msg, wpm, lpm);
}

int WINAPI	_tWinMain(HINSTANCE his, HINSTANCE hip, PTCHAR cdl, int swd)	{
	HWND	hwd, hdd;	/** main-window, dummy-for-tasktray **/
	MSG	msg;
	WNDCLASSEX	wcl;
	NOTIFYICONDATA	nid;
	RECT	crt, wrt;
	
	/** create dummy window for not appear on the taskbar **/
	ZeroMemory(&wcl, sizeof(wcl));
	wcl.cbSize = sizeof(wcl);
	wcl.lpfnWndProc = dummyWndProc;
	wcl.hInstance = his;
	wcl.lpszClassName = _T("DummyMain__");
	if	(
		!RegisterClassEx(&wcl)
		||	!(hdd = CreateWindowEx(0, _T("DummyMain__"), _T(""), WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, (HMENU)NULL, his, 0))
	)	{
		return	0;
	}
	
	/** create main window **/
	GetClientRect(hdd, &crt);
	GetWindowRect(hdd, &wrt);
	ZeroMemory(&wcl, sizeof(wcl));
	wcl.cbSize = sizeof(wcl);
	wcl.style = CS_BYTEALIGNCLIENT | CS_BYTEALIGNWINDOW;
	wcl.lpfnWndProc = windowProc;
	wcl.cbClsExtra = 0;
	wcl.cbWndExtra = 0;
	wcl.hInstance = his;
	wcl.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wcl.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
	wcl.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcl.hbrBackground = (HBRUSH)(COLOR_3DFACE + 1);
	wcl.lpszMenuName = NULL;
	wcl.lpszClassName = _T("FixwMain__");
	if	(
		!RegisterClassEx(&wcl)
	||	!(hwd = CreateWindowEx(
			WS_EX_CONTROLPARENT, _T("FixwMain__"), APP_NAME
		,	WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT
		,	WDT_WINDOW + ((wrt.right - wrt.left) - crt.right), HGT_WINDOW + (HGT_LABEL * 8) + ((wrt.bottom - wrt.top) - crt.bottom)
		,	hdd, (HMENU)NULL, his, 0
		))
	)	{
		return	0;
	}
	GetWindowRect(hwd, &oldRct);
	
	/** show on tasktray **/
	nid.cbSize = sizeof(nid);
	nid.uID = 1;
	nid.hWnd = hwd;
	nid.uFlags = NIF_ICON | NIF_MESSAGE | NIF_TIP;
	nid.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	nid.uCallbackMessage = WM_TASKTRAY;
	_tcscpy(nid.szTip, _T("fixw"));
	Shell_NotifyIcon(NIM_ADD, &nid);
	
	/** mainloop **/
	ShowWindow(hwd, swd);
	while	(GetMessage(&msg, NULL, 0, 0))	{
		if	(IsDialogMessage(hwd, &msg))	{	continue;	}
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	
	/** settle tasktray icon **/
	Shell_NotifyIcon(NIM_DELETE, &nid);
	return	msg.wParam;
}
