/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#ifndef __FK_BASE_HEADER__
#define __FK_BASE_HEADER__


const int FK_MAJOR_VERSION = 2;
const int FK_MINOR_VERSION = 8;
const int FK_SUBMINOR_VERSION = 5;

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <fstream>
#include <iostream>
#include <string>

#if !defined(WIN32) || defined(_CYGWIN_GCC_) || defined(_MINGW_)

#include <sys/unistd.h>
#include <sys/time.h>

#else

#pragma warning(disable : 4786)
#define snprintf _snprintf
#define vsnprintf _vsnprintf

#endif	// !WIN32 || _CYGWIN_GCC_

using namespace std;

const int FK_UNDEFINED = -1;

const double FK_EPS = 1.0e-8;
const double FK_PI = 3.1415926535897932;

enum fk_ObjectType {
	FK_BASEOBJECT,
	FK_IDADMIN,
	FK_FILEIO,
	FK_MATRIXADMIN,
	FK_MODEL,
	FK_DISPLAYLINK,
	FK_SCENE,
	FK_SHAPE,
	FK_TOPOLOGY,
	FK_POLYGON,
	FK_LINE,
	FK_POLYLINE,
	FK_POINT,
	FK_CIRCLE,
	FK_SPHERE,
	FK_BLOCK,
	FK_CLOSEDLINE,
	FK_PRISM,
	FK_CONE,
	FK_INDEXFACESET,
	FK_LIGHT,
	FK_BEZCURVE,
	FK_BSPLCURVE,
	FK_IMAGE,
	FK_TEXCOORD,
	FK_TEXTURE,
	FK_RECTTEXTURE,
	FK_TRITEXTURE,
	FK_MESHTEXTURE,
	FK_IFSTEXTURE,
	FK_UNICHAR,
	FK_UNISTR,
	FK_TEXTIMAGE,
	FK_COLOR,
	FK_MATERIAL,
	FK_MATERIALADMIN,
	FK_DRAW,
	FK_DRAWSET,
	FK_RGB,
	FK_REDRAW,
	FK_VSCALE,
	FK_HSCALE,
	FK_DRAWLIST,
	FK_PLANE,
	FK_WINDOW,
	FK_PICKDATA,
	FK_PROJECTBASE,
	FK_PERSPECTIVE,
	FK_ORTHO,
	FK_VERTEX,
	FK_HALF,
	FK_EDGE,
	FK_LOOP,
	FK_SOLIDBASE,
	FK_SOLID,
	FK_SHAPEVIEWER,
	FK_R_VERTEX,
	FK_R_HALF,
	FK_R_EDGE,
	FK_R_LOOP,
	FK_R_SOLID,
	FK_PARTICLE,
	FK_PARTICLESET
};

#ifdef NO_GL_LIBRARY

enum GLenum {
	GL_COLOR_INDEX,
	GL_STENCIL_INDEX,
	GL_DEPTH_INDEX,
	GL_RED,
	GL_GREEN,
	GL_BLUE,
	GL_ALPHA,
	GL_LUMINANCE,
	GL_LUMINANCE_ALPHA,
	GL_RGB,
	GL_BGR,
	GL_RGBA,
	GL_BGRA,
	GL_ABGR_EXT,
	GL_UNSIGNED_BYTE,
	GL_BYTE,
	GL_UNSIGNED_SHORT,
	GL_SHORT,
	GL_UNSIGNED_INT,
	GL_INT,
	GL_FLOAT,
	GL_BITMAP
};

typedef	int				GLint;
typedef unsigned int	GLuint;
typedef float			GLfloat;

#endif

class fk_BaseObject {

 private:

	fk_ObjectType	ObjectType;

 public:

	fk_BaseObject(fk_ObjectType argObjType = FK_BASEOBJECT);
	void			setObjectType(const fk_ObjectType);
	fk_ObjectType	getObjectType(void) const;
};

#endif /* !__FK_BASE_HEADER__ */
