/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#ifndef __FK_OPERATION_HEADER__
#define __FK_OPERATION_HEADER__

#include <vector>
#include <FK/DrawCache.h>
#include <FK/History.h>

/*
	用語 ---
		- 独立頂点
		稜線に接続していない頂点のこと。

		- 接続頂点
		稜線に接続している頂点のこと。

		- 任意頂点
		全ての頂点。

		- 未定義稜線
		両側のループが定義されていない稜線のこと。

		- 定義稜線
		両側、あるいは片側のループが定義されている稜線のこと。

		- 任意稜線
		全ての稜線。

		- 未定半義稜線
		親ループを保持する半稜線のこと。

		- 定義半稜線
		親ループを持たない半稜線のこと。


   ここで定義する変形操作 ---

   - makeVertex(fk_Vector)
	何もないところに頂点を生成する。その座標値に既に頂点があっても
	生成する。

   - deleteVertex(fk_Vertex *)
	稜線が接続されていない頂点(独立頂点)を消去する。稜線が接続
	されている場合はエラーになる。

   - moveVertex(fk_Vertex *, fk_Vector)
	指定された位置へ頂点を移動する。

   - makeEdge(fk_Vertex *v1, fk_Vertex *v2,
              fk_Half *h1_1, fk_Half *h1_2,
              fk_Half *h2_1, fk_Half *h2_2)
    頂点 v1 から v2 の間に未定義稜線を生成する。この関数は大きく以下の
	三通りの処理を行う。

		1. v1、v2 いずれも独立頂点の場合
			h1_1, h1_2, h2_1, h2_2 にはいずれも NULL を代入する。なお、
			h1_1 以下の引数は省略可能である。

		2. v1 が接続頂点、v2 が独立頂点の場合
			新たに生成される半稜線を h1, h2 (h1 の始点は v1)とする。
			このとき、h1_1 は h1 の前となる半稜線を、h1_2 には h2 の
			後となる半稜線を代入する。h2_1 及び h2_2 には NULL を
			代入する。なお、h2_1, h2_2 は省略可能である。なお、
			h1_1 及び h1_2 は未定義半稜線でなければならない。

		3. v1, v2 いずれも接続頂点の場合
			新たに生成される半稜線を h1, h2 (h1 の始点は v1)とする。
			このとき、
				- h1_1 は h1 の前
				- h1_2 は h2 の後
				- h2_1 は h1 の後
				- h2_2 は h2 の前
			となる半稜線を代入する。なお、h1_1, h1_2, h2_1, h2_2 の
			いずれも未定義半稜線でなければならない。

   - deleteEdge(fk_Edge *e1)
	稜線 e1 を削除する。e1 は未定義稜線でなければならない。

   - makeLoop(fk_Half *h1)
	h1 が未定義半稜線の場合、h1 が属するループを作成する。
	h1 が定義半稜線の場合はエラーとして NULL が返る。
	また、ループ内に共通の親稜線を持つ半稜線があった場合、
	エラーが出て NULL が返り新たにループは生成されない。

   - deleteLoop(fk_Loop *l1)
	l1 を削除する。

   - separateLoop(fk_Half *h1, fk_Half *h2)
	ループ内の h1 と h2 の間に定義稜線を生成し、ループを分割する。
	指定した両頂点が同一ループ内にない場合はエラーになる。なお、
	h1 と h2 は分割後新ループ側に属する。

   - uniteLoop(fk_Edge *e1)
	定義稜線を削除する。定義稜線で無い場合はエラーになり false が
	返る。通常は e1 の両側のループが結合して一つとなるが、ループを
	構成する半稜線の中で共通の親稜線を持つものがあった場合、
	ループは削除される。

   - separateEdge(fk_Edge *)
	任意稜線を分割し、新たな頂点を稜線の両端点の中点位置に生成する。

   - uniteEdge(fk_Vertex *)
	2 本の任意稜線に接続されている頂点を削除し、2 本の稜線を結合する。

   - negateBody(void)
	立体を反転する。

*/

#ifdef __FK_OPERATION_CODE__
static const int	MAKEV		= 1;
static const int	DELV		= 2;
static const int	MOVEV		= 3;
static const int	MAKEE1		= 4;
static const int	MAKEE2		= 5;
static const int	MAKEE3		= 6;
static const int	DELE1		= 7;
static const int	DELE2		= 8;
static const int	DELE3		= 9;
static const int	MAKEL		= 10;
static const int	DELL		= 11;
static const int	SEPL		= 12;
static const int	UNITL		= 13;
static const int	SEPE		= 14;
static const int	UNITE		= 15;
static const int	NEGATE		= 16;

#endif

class fk_Operation : public fk_DrawCache {

 private:
	fk_History		history;
	bool			historyMode;
	bool			tesselateMode;

	fk_Loop *		SetLoop(fk_Half *, bool,
							fk_Loop * = NULL, int = FK_UNDEFINED);
	void			UndefVNorm(fk_Vertex *);

	fk_Vertex *		MakeVertex(const fk_Vector, int);
	bool			DeleteVertex(fk_Vertex *);
	bool			MoveVertex(fk_Vertex *, fk_Vector);

	fk_Edge *		MakeEdge1(fk_Vertex *, fk_Vertex *,
							  int = FK_UNDEFINED,
							  int = FK_UNDEFINED,
							  int = FK_UNDEFINED);
	fk_Edge *		MakeEdge2(fk_Vertex *, fk_Vertex *,
							  fk_Half *, fk_Half *, bool, bool,
							  int = FK_UNDEFINED,
							  int = FK_UNDEFINED,
							  int = FK_UNDEFINED);
	fk_Edge *		MakeEdge3(fk_Vertex *, fk_Vertex *,
							  fk_Half *, fk_Half *,
							  fk_Half *, fk_Half *, bool, bool,
							  int = FK_UNDEFINED,
							  int = FK_UNDEFINED,
							  int = FK_UNDEFINED);

	bool			DeleteEdge1(fk_Edge *);
	bool			DeleteEdge2(fk_Half *);
	bool			DeleteEdge3(fk_Edge *);

	fk_Loop *		MakeLoop(fk_Half *, int = FK_UNDEFINED);
	bool			DeleteLoop(fk_Loop *);

	fk_Edge *		SeparateLoop(fk_Half *, fk_Half *, fk_Half *, fk_Half *,
								 bool, bool,
								 int = FK_UNDEFINED,
								 int = FK_UNDEFINED,
								 int = FK_UNDEFINED,
								 int = FK_UNDEFINED);

	bool			UniteLoop(fk_Edge *, fk_Half *);
	fk_Vertex *		SeparateEdge(fk_Edge *, bool, bool, bool, bool,
								 fk_Vector *,
								 int = FK_UNDEFINED,
								 int = FK_UNDEFINED,
								 int = FK_UNDEFINED,
								 int = FK_UNDEFINED);

	bool			UniteEdge(fk_Vertex *);
	void			NegateBody(void);


	void			UndoCom(fk_Command *);
	void			RedoCom(fk_Command *);

 public:
	fk_Operation(fk_DataBase * = (fk_DataBase *)NULL);
	~fk_Operation();

	fk_Vertex *		makeVertex(const fk_Vector);
	bool			deleteVertex(fk_Vertex *);
	bool			moveVertex(fk_Vertex *, fk_Vector);
	fk_Edge *		makeEdge(fk_Vertex *, fk_Vertex *,
							 fk_Half * = (fk_Half *)NULL,
							 fk_Half * = (fk_Half *)NULL,
							 fk_Half * = (fk_Half *)NULL,
							 fk_Half * = (fk_Half *)NULL);
	bool			deleteEdge(fk_Edge *);
	fk_Loop *		makeLoop(fk_Half *);
	bool			deleteLoop(fk_Loop *);
	fk_Edge *		separateLoop(fk_Half *, fk_Half *);
	bool			uniteLoop(fk_Edge *);
	fk_Vertex *		separateEdge(fk_Edge *);
	bool			uniteEdge(fk_Vertex *);
	void			negateBody(void);

	void			setHistoryMode(bool);
	bool			getHistoryMode(void);
	void			setHistoryMark(void);
	bool			undoHistory(void);
	bool			redoHistory(void);

	void			printHistorySize(void);

	void			setTesselateMode(bool);
	bool			getTesselateMode(void);
	void			deleteAllTesselateData(void);
};


#endif // !__FK_OPERATION_HEADER__
