/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#include <FK/IDAdmin.h>

using namespace std;

fk_IDAdmin::fk_IDAdmin(int argOrder)
{
	eraseIDSet = (list<int> *)NULL;
	Init(argOrder);

	return;
}

fk_IDAdmin::~fk_IDAdmin()
{
	delete eraseIDSet;
	existFlagSet.clear();
	return;
}

void fk_IDAdmin::CloneData(fk_IDAdmin *argIDA)
{
	list<int>::iterator		eraseP;
	vector<char>::iterator	existP;

	order = argIDA->order;
	MaxID = argIDA->MaxID;
	eraseIDSet->clear();
	existFlagSet.clear();

	for(eraseP = argIDA->eraseIDSet->begin();
		eraseP != argIDA->eraseIDSet->end(); eraseP++) {
		eraseIDSet->push_back(*eraseP);
	}
	for(existP = argIDA->existFlagSet.begin();
		existP != argIDA->existFlagSet.end(); existP++) {
		existFlagSet.push_back(*existP);
	}

	return;
}	 

void fk_IDAdmin::Init(int argOrder)
{
	order = argOrder;
	MaxID = order - 1;

	delete eraseIDSet;
	eraseIDSet = new list<int>;
	existFlagSet.clear();

	return;
}

void fk_IDAdmin::Resize(int argSize)
{
	unsigned int		i;

	Init(order);

	MaxID = (argSize > 0) ? argSize + order - 1 : order - 1;
	existFlagSet.resize(argSize);
	for(i = 0; i < (unsigned int)(argSize); i++) {
		existFlagSet[i] = char(1);
	}

	return;
}

int fk_IDAdmin::NewID(void) const
{
	if(eraseIDSet->empty()) {
		return MaxID + 1;
	} else {
		return eraseIDSet->back();
	}
}

int fk_IDAdmin::CreateID(void)
{
	int retID;

	if(eraseIDSet == (list<int> *)NULL) {
		eraseIDSet = new list<int>;
	}

	if(eraseIDSet->empty() == true) {
		retID = MaxID + 1;
		MaxID++;
		existFlagSet.push_back(char(1));
	} else {
		retID = eraseIDSet->back();
		eraseIDSet->pop_back();
		existFlagSet[retID-order] = char(1);
	}

	return retID;
}

bool fk_IDAdmin::CreateID(int argID)
{
	if(argID < order || argID > MaxID) {
		return false;
	}

	if(existFlagSet[argID-order] == char(1)) {
		return false;
	}

	existFlagSet[argID-order] = char(1);
	eraseIDSet->remove(argID);
	return true;
}

bool fk_IDAdmin::EraseID(int argID)
{
	if(ExistID(argID) == false) return false;
	eraseIDSet->push_back(argID);
	existFlagSet[argID-order] = char(0);

	return true;
}


bool fk_IDAdmin::ExistID(int argID) const
{
	if(argID > MaxID || argID < order) return false;
	if(existFlagSet.size() <= std::vector<char>::size_type(argID - order)) {
		return false;
	}
	if(existFlagSet[argID-order] == char(1)) return true;
	return false;
}

int fk_IDAdmin::GetMaxID(void) const
{
	int tmpMaxID;

	if(GetIDNum() == 0) return order-1;

	tmpMaxID = MaxID;
	while(ExistID(tmpMaxID) == false) {
		tmpMaxID--;
	}

	return tmpMaxID;
}

int fk_IDAdmin::GetIDNum(void) const
{
	return MaxID - eraseIDSet->size() - order + 1;
}

int fk_IDAdmin::GetNext(int argID) const
{
	int tmpID;

	// 最初の要素を返す
	if(argID > MaxID) return order;

	// NULL 相当を返す
	if(argID == MaxID) return order-1;

	// 検索候補
	if(argID < order) {
		// 最初の要素
		tmpID = order;
	} else {
		tmpID = argID + 1;
	}

	// 検索
	while(existFlagSet[tmpID-order] == char(0) && tmpID <= MaxID) {
		tmpID++;
	}
	// NULL 相当を返す
	if(tmpID == MaxID + 1) return order-1;

	// 検索結果
	return tmpID;
}

int fk_IDAdmin::GetOrder(void) const
{
	return order;
}
