#!/usr/local/bin/perl

my $secStart = 0;
my $comStart = 0;
my $refStart = 0;
my $extStart = 0;
my $verbMode = 0;
my $title = "";


while(<STDIN>) {
	$line = $_;
	chop $line;
	$line =~ s/^\s*//;
	$line =~ s/\\\(//;
	$line =~ s/\\\)//;
	@list = split(/\s/, $line);
	$oldKey = $key;
	$key = $list[0];
	shift(@list);
	$str = join(' ', @list);

	if($verbMode == 1) {
		if($key eq '$VERBEND') {
			$verbMode = 0;
			print "\t" . '</PRE>' . "\n";
			print "\t" . '</FONT>' . "\n";
		} else {
			print $_;
		}
	} elsif($key eq '$VERBBEGIN') {
		$verbMode = 1;
		print "\t" . '<FONT COLOR="#aaffff">' . "\n";
		print "\t" . '<PRE>' . "\n";
	} elsif($key eq '$TITLE') {
		$title = $str;
	} elsif($key eq '$VER') {
		print '<HTML lang="ja">' . "\n";
		print '<HEAD>' . "\n";
		print "\t" . '<TITLE> Sample </TITLE>' . "\n";
		print "\t" . '<META http-equiv="Content-Type" ' .
			'content="text/html; charset=EUC-JP">' . "\n";
		print '</HEAD>' . "\n\n";
		print '<BODY TEXT="#dddddd" BGCOLOR="#444444"' . "\n";
		print "\t" . 'link="#ffff66" ';
		print 'vlink="#ffff66" alink="#ffff66">' . "\n";
		print "\t" . '<CENTER> <H1> ' .
			$title . ' (Ver ' . $str .
			') </H1> </CENTER>' . "\n";
	} elsif($key eq '$SEC' || $key eq '$SUBSEC') {
		if($secStart != 0) {
			if($extStart != 0) {
				print "\t\t" . '</DL>' . "\n";
			}
			print "\t" . '</DL>' . "\n";
		} else {
			$secStart = 1;
		}
		if($key eq '$SEC') {
			print "\t<FONT COLOR=\"#55ff55\">\n";
			print "\t<CENTER> <H2> $str </H2> </CENTER>\n";
			print "\t</FONT>\n";
		} else {
			print "\t<FONT COLOR=\"#ccccff\">\n";
			print "\t<CENTER> <H3>";
			print " ---- $str ---- ";
			print "</H3> </CENTER> \n";
			print "\t</FONT>\n";
		}
		print "\t<DL>\n";

		$refStart = 0;
		$comStart = 0;
		$extStart = 0;
	} elsif($key eq '$COM') {
		if($comStart != 0 && $extStart != 0) {
			print "\t\t</DL>\n";
		}
		if($refStart != 0) {
			print "\t\t<BR><BR>\n";
		}
		print "\t\t<DT> <CODE>\n";
		print "\t\t<FONT COLOR=\"#ffff66\"> $str </FONT> </CODE>\n";
		print "\t\t<DD>\n";
		$extStart = 0;
		$refStart = 0;
		$comStart = 1;
	} elsif($key eq '$REF') {
		$refStart = 1;
		print "\t\t" . $str . "\n";
	} elsif($key eq '$EXT') {
		if($extStart == 0) {
			print "\t\t<DL COMPACT>\n";
		}
		$extStart++;
		if($oldKey ne '$EXT') {
			print "\t\t\t<DT>  $extStart : \n";
		} else {
			print "\t\t\t<DT> \n";
		}
		print "\t\t\t<DD> <KBD>\n";
		print "\t\t\t<FONT COLOR=\"#ff00ff\"> $str </FONT>\n";
		print "\t\t\t</KBD> <BR>\n";
	} elsif($key eq '$MAN') {
		print "\t\t\t" . $str . "\n";
	} elsif($key eq '$ITEMBEGIN') {
		print "\t\t<BR><BR><UL>\n";
	} elsif($key eq '$ITEM') {
		print "\t\t\t<LI> " . $str . "\n";
	} elsif($key eq '$ITEMEND') {
		print "\t\t</UL><BR>\n";
	}
}

print "\t\t</DL>\n";
print "\t</DL>\n";
print "<A HREF=\"./index.html\"> 롣</A>\n";
print "<HR>\n";
print "<ADDRESS>  (earth\@media.teu.ac.jp) </ADDRESS>\n";
print "</BODY>\n";
print "</HTML>\n";
