/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#include <TinyFK/TFK_Line.h>
#include "TFK_API.h"

TFK_Line::TFK_Line(void)
{
	base = TFK_API::getBasePointer()->getLineBase();
	return;
}

TFK_Line::TFK_Line(const TFK_Line &argL)
{
	id = argL.id;
	base = argL.base;
}

TFK_Line::~TFK_Line()
{
	return;
}

TFK_Line & TFK_Line::operator =(const TFK_Line &argL)
{
	id = argL.id;
	base = argL.base;

	return *this;
}

bool TFK_Line::isArive(void)
{
	if(id == -1) return false;
	if(base->isArive(id) == false) {
		id = -1;
		return false;
	}
	return true;
}

void TFK_Line::setPalette(int argCID)
{
	if(isArive() == false) return;

	base->changePalette(id, argCID);
	return;
}

int TFK_Line::getPalette(void)
{
	if(isArive() == false) return -1;
	return base->getPalette(id);
}

fk_Vector TFK_Line::getStartPos(void)
{
	fk_Vector	pos(0.0, 0.0, 0.0);

	if(isArive() == false) return pos;
	return base->getPos(id, 0);
}

fk_Vector TFK_Line::getEndPos(void)
{
	fk_Vector	pos(0.0, 0.0, 0.0);

	if(isArive() == false) return pos;
	return base->getPos(id, 1);
}

void TFK_Line::setWidth(double argWidth)
{
	if(isArive() == false) return;
	base->setWidth(id, argWidth);
	return;
}

double TFK_Line::getWidth(void)
{
	if(isArive() == false) return 0.0;
	return base->getWidth(id);
}

int TFK_Line::create(double argX1, double argY1, double argX2, double argY2)
{
	fk_Vector		sV(argX1, argY1, 0.0), eV(argX2, argY2, 0.0);

	id = base->create(sV, eV);
	return id;
}

int TFK_Line::create(double argX1, double argY1, double argZ1,
					 double argX2, double argY2, double argZ2)
{
	fk_Vector		sV(argX1, argY1, argZ1), eV(argX2, argY2, argZ2);

	id = base->create(sV, eV);
	return id;
}

int TFK_Line::create(fk_Vector argV1, fk_Vector argV2)
{
	id = base->create(argV1, argV2);
	return id;
}

void TFK_Line::move(double argX1, double argY1, double argX2, double argY2)
{
	fk_Vector		sV(argX1, argY1, 0.0), eV(argX2, argY2, 0.0);

	if(isArive() == false) return;

	base->move(id, sV, eV);
	return;
}

void TFK_Line::move(double argX1, double argY1, double argZ1,
					double argX2, double argY2, double argZ2)
{
	fk_Vector		sV(argX1, argY1, argZ1), eV(argX2, argY2, argZ2);

	if(isArive() == false) return;

	base->move(id, sV, eV);
	return;
}

void TFK_Line::move(fk_Vector argV1, fk_Vector argV2)
{
	if(isArive() == false) return;

	base->move(id, argV1, argV2);
	return;
}

void TFK_Line::translate(double argX, double argY, double argZ)
{
	fk_Vector	pos(argX, argY, argZ);

	if(isArive() == false) return;

	base->translate(id, pos);
	return;
}

void TFK_Line::translate(fk_Vector argPos)
{
	if(isArive() == false) return;

	base->translate(id, argPos);
	return;
}

void TFK_Line::clear(void)
{
	if(isArive() == false) return;

	base->clear(id);
	id = -1;
	return;
}
