/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#include <TinyFK/TFK_Point.h>
#include "TFK_API.h"

TFK_Point::TFK_Point(void)
{
	base = TFK_API::getBasePointer()->getPointBase();

	return;
}

TFK_Point::TFK_Point(const TFK_Point &argP)
{
	id = argP.id;
	base = argP.base;
}

TFK_Point::~TFK_Point()
{
	return;
}

TFK_Point & TFK_Point::operator =(const TFK_Point &argP)
{
	id = argP.id;
	base = argP.base;

	return *this;
}

bool TFK_Point::isArive(void)
{
	if(id == -1) return false;
	if(base->isArive(id) == false) {
		id = -1;
		return false;
	}
	return true;
}

void TFK_Point::setPalette(int argCID)
{
	if(isArive() == false) return;

	base->changePalette(id, argCID);
	return;
}

int TFK_Point::getPalette(void)
{
	if(isArive() == false) return -1;
	return base->getPalette(id);
}

void TFK_Point::setSize(double argSize)
{
	if(isArive() == false) return;
	base->setSize(id, argSize);
	return;
}

double TFK_Point::getSize(void)
{
	if(isArive() == false) return 0.0;
	return base->getSize(id);
}

fk_Vector TFK_Point::getPos(void)
{
	fk_Vector	pos(0.0, 0.0, 0.0);

	if(isArive() == false) return pos;
	return base->getPos(id);
}

int TFK_Point::create(double argX, double argY, double argZ)
{
	fk_Vector	pos(argX, argY, argZ);

	id = base->create(pos);
	return id;
}

int TFK_Point::create(fk_Vector argPos)
{
	id = base->create(argPos);
	return id;
}

void TFK_Point::move(double argX, double argY, double argZ)
{
	fk_Vector	pos(argX, argY, argZ);

	if(isArive() == false) return;

	base->move(id, pos);
	return;
}

void TFK_Point::move(fk_Vector argPos)
{
	if(isArive() == false) return;

	base->move(id, argPos);
	return;
}

void TFK_Point::translate(double argX, double argY, double argZ)
{
	fk_Vector	pos(argX, argY, argZ);

	if(isArive() == false) return;

	base->translate(id, pos);
	return;
}

void TFK_Point::translate(fk_Vector argPos)
{
	if(isArive() == false) return;

	base->translate(id, argPos);
	return;
}

void TFK_Point::clear(void)
{
	if(isArive() == false) return;

	base->clear(id);
	id = -1;
	return;
}
