/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#ifndef __FK_MATERIAL_HEADER__
#define __FK_MATERIAL_HEADER__

#include <FK/Base.h>

const float FK_COLOR_EPS = 0.0001f;

class fk_Color : public fk_BaseObject {
 public:
	float col[4];
	fk_Color(float = 0.2f, float = 0.2f, float = 0.2f);
	fk_Color(double, double, double);
	~fk_Color() {}
	friend bool operator ==(fk_Color, fk_Color);
	fk_Color(const fk_Color &);
	fk_Color & operator =(const fk_Color &);

	void		init(void);
	void		init(float, float, float, float = 1.0f);
	void		init(double, double, double, double = 1.0);
	void		set(float, float, float, float = 1.0f);
	void		set(double, double, double, double = 1.0);
	void		setR(float);
	void		setG(float);
	void		setB(float);
	void		setA(float);

	void		setR(double);
	void		setG(double);
	void		setB(double);
	void		setA(double);

	float		getR(void) const;
	float		getG(void) const;
	float		getB(void) const;
	float		getA(void) const;
};

class fk_Material : public fk_BaseObject {

 private:
	float		alpha;
	fk_Color	ambient;
	fk_Color	diffuse;
	fk_Color	emission;
	fk_Color	specular;
	float		shininess;

 public:
	fk_Material();
	~fk_Material() {}
	friend int operator==(fk_Material, fk_Material);
	fk_Material(const fk_Material &);
	fk_Material & operator =(const fk_Material &);

	void		init(void);
	void		setAlpha(float);
	void		setAlpha(double);
	void		setAmbient(fk_Color);
	void		setAmbient(float, float, float);
	void		setAmbient(double, double, double);
	void		setDiffuse(fk_Color);
	void		setDiffuse(float, float, float);
	void		setDiffuse(double, double, double);
	void		setEmission(fk_Color);
	void		setEmission(float, float, float);
	void		setEmission(double, double, double);
	void		setSpecular(fk_Color);
	void		setSpecular(float, float, float);
	void		setSpecular(double, double, double);
	void		setAmbDiff(fk_Color);
	void		setAmbDiff(float, float, float);
	void		setAmbDiff(double, double, double);
	void		setShininess(float);
	void		setShininess(double);

	float		getAlpha(void);
	fk_Color *	getAmbient(void);
	fk_Color *	getDiffuse(void);
	fk_Color *	getEmission(void);
	fk_Color *	getSpecular(void);
	float		getShininess(void);
	void		Print(int, std::string = "");
};

#endif // __FK_MATERIAL_HEADER__
