/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#ifndef __FK_MATRIX_HEADER__
#define __FK_MATRIX_HEADER__

#include <FK/Vector.h>
#include <FK/Angle.h>

const double FK_MATRIX_EPS = 1.0e-12;
const double FK_MATRIX_EPS2 = 1.0e-16;

/////////////////////// ユニタリー行列用クラス 

// 行列積 
fk_UnitMatrix operator *(const fk_UnitMatrix &, const fk_UnitMatrix &);

// 行列変換 
//fk_Vector operator *(const fk_Vector &, const fk_UnitMatrix &);

class fk_UnitMatrix {
	friend class	fk_Matrix;

 protected:

	double	m[4][4];
	void	MultVec(fk_HVector &, const fk_HVector &) const;

 public:

	fk_UnitMatrix(void);					// 単位行列生成 
	fk_UnitMatrix(const fk_UnitMatrix &);	// コピーコンストラクタ 

	// 単位行列または零行列の生成 
	void			init(void);
	void			set(int, int, double);
	bool			inverse(void);			// 自身を逆行列化し、結果を返す 
	void			negate(void);			// 自身を転置する 

	// XYZ 軸回転行列 (角度(ラジアン), 回転軸 {FK_X, FK_Y, FK_Z}) 
	void			makeRot(double, fk_Axis);

	// 平行移動行列 
	void			makeTrans(double, double, double);	
	void			makeTrans(const fk_Vector &);

	// オイラー角回転行列 (Heading, Pitch, Roll) 
	void			makeEuler(double, double, double);
	void			makeEuler(const fk_Angle &);
	
	// 行列要素の標準出力 
	void			Print(std::string = "") const;

	// 単項演算子  
	fk_UnitMatrix	operator !(void) const;		// 逆行列を返す(自身は不変) 
	double *		operator [](int);			// メンバ行へのアクセス 


	// 比較演算子 
	bool	operator ==(const fk_UnitMatrix &) const;
	bool	operator !=(const fk_UnitMatrix &) const;

	// 代入演算子 

	fk_UnitMatrix &		operator =(const fk_UnitMatrix &);	// 代入 
	fk_UnitMatrix &		operator *=(const fk_UnitMatrix &);	// 積 

	friend fk_Vector & fk_Vector::operator *=(const fk_UnitMatrix &);
	friend fk_HVector & fk_HVector::operator *=(const fk_UnitMatrix &);

	// 行列変換 
	friend fk_HVector		operator *(const fk_UnitMatrix &,
									   const fk_HVector &);
	// 行列積 
	friend fk_UnitMatrix	operator *(const fk_UnitMatrix &,
									   const fk_UnitMatrix &);
	friend fk_Matrix	operator *(const fk_Matrix &, const fk_UnitMatrix &);
	friend fk_Matrix	operator *(const fk_UnitMatrix &, const fk_Matrix &);

	// 行列和 
	friend fk_Matrix	operator +(const fk_Matrix &, const fk_UnitMatrix &);
	friend fk_Matrix	operator +(const fk_UnitMatrix &, const fk_Matrix &);
	// 行列差 
	friend fk_Matrix	operator -(const fk_Matrix &, const fk_UnitMatrix &);
	friend fk_Matrix	operator -(const fk_UnitMatrix &, const fk_Matrix &);
};

/////////////////////// 4x4 汎用行列クラス 

class fk_Matrix : public fk_UnitMatrix {

 public:

	fk_Matrix(void);						// 単位行列生成 
	fk_Matrix(const fk_Matrix &);			// コピーコンストラクタ 

	bool			inverse(void);			// 自身を逆行列化し、結果を返す 
	bool			isSingular(void) const;	// 特異行列判定 
	bool			isRegular(void) const;	// 正則行列判定 

	// 拡大縮小行列 
	void			makeScale(double, double, double);
	void			makeScale(const fk_Vector &);

	// 単項演算子  
	fk_Matrix		operator !(void) const;	// 逆行列を返す(自身は不変) 

	// 比較演算子 
	bool	operator ==(const fk_Matrix &) const;
	bool	operator !=(const fk_Matrix &) const;

	// 代入演算子 

	fk_Matrix &		operator =(const fk_Matrix &);		// 代入 
	fk_Matrix &		operator =(const fk_UnitMatrix &);	// 代入 
	fk_Matrix &		operator +=(const fk_Matrix &);		// 和 
	fk_Matrix &		operator +=(const fk_UnitMatrix &);	// 和 
	fk_Matrix &		operator -=(const fk_Matrix &);		// 差 
	fk_Matrix &		operator -=(const fk_UnitMatrix &);	// 差 
	fk_Matrix &		operator *=(const fk_Matrix &);		// 積 
	fk_Matrix &		operator *=(const fk_UnitMatrix &);	// 積 

	friend fk_Vector & fk_Vector::operator *=(const fk_Matrix &);
	friend fk_HVector & fk_HVector::operator *=(const fk_Matrix &);
	// 二項演算子 
	// 行列変換 
	friend fk_HVector	operator *(const fk_Matrix &, const fk_HVector &);
	// 行列和 
	friend fk_Matrix	operator +(const fk_Matrix &, const fk_Matrix &);
	friend fk_Matrix	operator +(const fk_Matrix &, const fk_UnitMatrix &);
	friend fk_Matrix	operator +(const fk_UnitMatrix &, const fk_Matrix &);
	// 行列差 
	friend fk_Matrix	operator -(const fk_Matrix &, const fk_Matrix &);
	friend fk_Matrix	operator -(const fk_Matrix &, const fk_UnitMatrix &);
	friend fk_Matrix	operator -(const fk_UnitMatrix &, const fk_Matrix &);
	// 行列積 
	friend fk_Matrix	operator *(const fk_Matrix &, const fk_Matrix &);
	friend fk_Matrix	operator *(const fk_Matrix &, const fk_UnitMatrix &);
	friend fk_Matrix	operator *(const fk_UnitMatrix &, const fk_Matrix &);

};

fk_Vector	fk_DivideVec(const fk_Vector &, const fk_Vector &,
						 const fk_Vector &, const fk_Vector &);

#endif	/* !__FK_MATRIX_HEADER__ */
