/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#ifndef __FK_MODEL_HEADER__
#define __FK_MODEL_HEADER__

#include <FK/MatAdmin.h>
#include <FK/Palette.h>
#include <FK/Angle.h>

class fk_Material;
class fk_Shape;
class fk_TreeData;

typedef unsigned int fk_DrawMode;

const fk_DrawMode FK_NONEMODE			= 0x0000;
const fk_DrawMode FK_POINTMODE			= 0x0001;
const fk_DrawMode FK_LINEMODE			= 0x0002;
const fk_DrawMode FK_POLYMODE			= 0x0004;
const fk_DrawMode FK_BACK_POLYMODE		= (0x0008 | FK_POLYMODE);
const fk_DrawMode FK_FRONTBACK_POLYMODE	= (0x0010 | FK_POLYMODE);

enum fk_BoundaryMode {
	FK_SPHERE_B,
	FK_BOX_B,
	FK_CAPSULE_B
};

class fk_Model : public fk_MatrixAdmin {

 private:
	fk_Material			*material;		// Model Material
	fk_Color			*pointColor;	// Color for Point
	fk_Color			*lineColor;		// Color for Line
	fk_Shape			*shape;			// Shape Pointer
	fk_Model			*parent;		// Parent Model Pointer
	bool				materialFlag;	// Flag which This Model has Material
	fk_DrawMode			drawMode;
	fk_MaterialMode		materialMode;
	double				drawSize;
	double				drawWidth;
	bool				pickFlag;
	bool				smoothFlag;
	bool				reverseFlag;
	bool				treeFlag;
	unsigned int		_modelID;

	fk_BoundaryMode		boundaryMode;

	fk_HVector			snapPos;
	fk_HVector			snapInhPos;
	fk_Angle			snapAngle;
	bool				snapFlag;

	double				sbRadius;

	void				EntryTree(void);
	void				DeleteTree(void);
	fk_TreeData *		GetTreeData(fk_Model *);

 public:
	fk_Model(fk_Shape * = (fk_Shape *)NULL);

	virtual ~fk_Model();
	void					setShape(fk_Shape *);
	void					setMaterial(const fk_Material &);
	void					setPointColor(fk_Color *);
	void					setPointColor(float, float, float);
	void					setLineColor(fk_Color *);
	void					setLineColor(float, float, float);

	fk_Shape *				getShape(void) const;
	fk_Material *			getMaterial(void);
	fk_Material *			getInhMaterial(void);
	fk_Color *				getPointColor(void);
	fk_Color *				getInhPointColor(void);
	fk_Color *				getLineColor(void);
	fk_Color *				getInhLineColor(void);

	void					deleteMaterial(void);
	void					deletePointColor(void);
	void					deleteLineColor(void);
	void					setDrawMode(const fk_DrawMode);
	fk_DrawMode				getDrawMode(void) const;
	void					setMaterialMode(const fk_MaterialMode);
	fk_MaterialMode			getMaterialMode(void) const;

	fk_Matrix				getInhMatrix(void) const;
	fk_Matrix				getInhInvMatrix(void) const;
	fk_UnitMatrix			getInhBaseMatrix(void) const;
	fk_UnitMatrix			getInhInvBaseMatrix(void) const;
	fk_Vector				getInhPosition(void) const;
	fk_Vector				getInhVec(void) const;
	fk_Vector				getInhUpVec(void) const;
	fk_Angle				getInhAngle(void) const;

	bool					setParent(fk_Model *, bool = false);
	void					deleteParent(bool = false);
	fk_Model *				getParent(void) const;
	bool					entryChild(fk_Model *, bool = false);
	bool					deleteChild(fk_Model *, bool = false);
	void					deleteChildren(bool = false);
	fk_Model *				foreachChild(fk_Model *);

	void					setSize(const double);
	void					setWidth(const double);
	double					getSize(void) const;
	double					getWidth(void) const;

	void					setPickMode(const bool);
	bool					getPickMode(void) const;
	void					setSmoothMode(const bool);
	bool					getSmoothMode(void) const;
	void					setReverseDrawMode(const bool);
	bool					getReverseDrawMode(void) const;

	void					snapShot(void);
	bool					restore(void);
	bool					restore(double);

	void					setBoundaryMode(fk_BoundaryMode);
	fk_BoundaryMode			getBoundaryMode(void);
	void					setSBRadius(double);
	double					getSBRadius(void);
	bool					isInterference(fk_Model *);
	bool					isCollision(fk_Model *);
	double					getCollisionTime(fk_Model *);
	
	virtual void			preShader(void) {};
	virtual void			postShader(void) {};
	// rita_ext: カスタムテクスチャ描画用エントリポイント
	virtual void			connectShader(unsigned int) {};

	unsigned int			getID(void) const;
	void					TreePrint(void);
};

#endif // !__FK_MODEL_HEADER__
