/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#ifndef __FK_QUATERNION_HEADER__
#define __FK_QUATERNION_HEADER__

#include <FK/Vector.h>
#include <FK/Angle.h>
#include <FK/Matrix.h>

class fk_Quaternion {
 public:
	double		s; // スカラー部
	fk_Vector	v; // ベクトル部

	fk_Quaternion(void);

	// コンストラクタ (s, x, y, z)
	fk_Quaternion(double, double, double, double);

	// コンストラクタ (s, v)
	fk_Quaternion(const double, const fk_Vector &);

	// コピーコンストラクタ
	fk_Quaternion(const fk_Quaternion &);

	// 初期化 (s, x, y, z) = (1, 0, 0, 0)
	void		init(void);

	// 設定 (s, x, y, z)
	void		set(double, double, double, double);
	void		set(double, const fk_Vector &);

	// 設定 (角度 + 回転軸)
	void		setRotate(double, double, double, double);
	void		setRotate(double, const fk_Vector &);

	// オイラー角変換
	void		makeEuler(double, double, double);
	void		makeEuler(const fk_Angle &);
	fk_Angle &	getEuler(void) const;

	double		norm(void) const;		// ノルム
	double		abs(void) const;		// 絶対値
	bool		normalize(void);		// 正規化
	bool		inverse(void);			// 逆元化
	void		conj(void);				// 共役化

	// 行列変換
	fk_Matrix &	conv(void) const;

	// 単項演算子
	fk_Quaternion &		operator !(void) const;	// 逆元を返す(自身は不変)
	fk_Quaternion &		operator ~(void) const; // 共役を返す(自身は不変)
	fk_Quaternion &		operator -(void) const; // 符号転換(自身は不変)

	// 代入演算子
	fk_Quaternion &		operator =(const fk_Quaternion &);

	// 積代入演算
	fk_Quaternion &		operator *=(const fk_Quaternion &);

	// スカラー倍代入演算
	fk_Quaternion &		operator *=(double);
	fk_Quaternion &		operator /=(double);

	// 加減算代入演算
	fk_Quaternion &		operator +=(const fk_Quaternion &);
	fk_Quaternion &		operator -=(const fk_Quaternion &);

	// 比較演算子
	bool				operator ==(const fk_Quaternion &) const;
	bool				operator !=(const fk_Quaternion &) const;

	// 二項演算子
	// 積
	friend fk_Quaternion	operator *(const fk_Quaternion &,
									   const fk_Quaternion &);
	// 和
	friend fk_Quaternion	operator +(const fk_Quaternion &,
									   const fk_Quaternion &);
	// 差
	friend fk_Quaternion	operator -(const fk_Quaternion &,
									   const fk_Quaternion &);

	// スカラー倍
	friend fk_Quaternion	operator *(const fk_Quaternion &, double);
	friend fk_Quaternion	operator *(double, const fk_Quaternion &);
	friend fk_Quaternion	operator /(const fk_Quaternion &, double);

	// ベクトル変換
	friend fk_Vector		operator *(const fk_Quaternion &,
									   const fk_Vector &);

	// 内積 (演算子優先度が低いことに注意)
	friend double			operator ^(const fk_Quaternion &,
									   const fk_Quaternion &);
};

// 線形補間 (Q1, Q2, t) (0 <= t <= 1)
fk_Quaternion & fk_Q_Inter_Linear(const fk_Quaternion &,
								  const fk_Quaternion &, double);

// 球面補間 (Q1, Q2, t) (0 <= t <= 1)
fk_Quaternion & fk_Q_Inter_Sphere(const fk_Quaternion &,
								  const fk_Quaternion &, double);

#endif // !__FK_QUATERNION_HEADER__
