/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#ifndef __FK_VECTOR_HEADER__
#define __FK_VECTOR_HEADER__

#include <FK/Base.h>
#include <string>
#include <vector>

const double FK_VECTOREPS = 1.0e-12;

enum fk_Axis {
	fk_X,
	fk_Y,
	fk_Z
};

class fk_UnitMatrix;
class fk_Matrix;
class fk_FVector;

class fk_Vector {

 public:
	double x, y, z;

	fk_Vector(double = 0.0, double = 0.0, double = 0.0);
	fk_Vector(const fk_Vector &);
	fk_Vector(const fk_FVector &);
	virtual ~fk_Vector() {}

	// 単項マイナス演算子 
	fk_Vector &			operator -(void) const;

	// 同値比較演算子 
	bool				operator ==(const fk_Vector &) const;

	// 異値比較演算子 
	bool				operator !=(const fk_Vector &) const;

	// ヒープ用不等号演算子 
	bool				operator >(const fk_Vector &) const;
	bool				operator <(const fk_Vector &) const;
	bool				operator >=(const fk_Vector &) const;
	bool				operator <=(const fk_Vector &) const;

	// 代入演算子 
	fk_Vector &			operator =(const fk_Vector &);		// 代入 
	fk_Vector &			operator =(const fk_FVector &);		// 代入 
	fk_Vector &			operator *=(double);				// 実数積 
	fk_Vector &			operator /=(double);				// 実数商 
	fk_Vector &			operator +=(const fk_Vector &);		// 単項和 
	fk_Vector &			operator -=(const fk_Vector &);		// 単項差 
	fk_Vector &			operator *=(const fk_Matrix &);		// 行列変換 
	fk_Vector &			operator *=(const fk_UnitMatrix &);	// 行列変換 


	virtual void	set(double, double, double = 0.0);// 値のセット 
	double			dist(void) const;				// 距離出力 
	double			dist2(void) const;				// 距離平方出力 
	bool			normalize(void);				// 正規化 
	virtual void	init(void);						// 初期化 
	bool			isZero(void) const;				// 零ベクトル判定 
	fk_Vector		proj(const fk_Vector &) const;	// 射影ベクトル 
	fk_Vector		perp(const fk_Vector &) const;	// 垂直成分ベクトル 
	virtual void	Print(void) const;				// 標準出力 
	virtual void	Print(std::string) const;		// 標準出力 

	///// friend 演算子群 
	// 内積演算子 
	friend double		operator *(const fk_Vector &, const fk_Vector &);

	// 和演算子 
	friend fk_Vector	operator +(const fk_Vector &, const fk_Vector &);

	// 差演算子 
	friend fk_Vector	operator -(const fk_Vector &, const fk_Vector &);

	// 実数倍演算子 
	friend fk_Vector	operator *(const fk_Vector &, double);

	// 実数倍演算子 
	friend fk_Vector	operator *(double, const fk_Vector &);

	// 実数商演算子 
	friend fk_Vector	operator /(const fk_Vector &, double);

	// 外積演算子 
	friend fk_Vector	operator ^(const fk_Vector &, const fk_Vector &);
};

class fk_HVector: public fk_Vector {
 public:
	double	w;

	fk_HVector(void);
	fk_HVector(const fk_Vector &, double = 1.0);
	virtual ~fk_HVector() {}
	fk_HVector(const fk_HVector &);
	bool			operator ==(const fk_HVector &) const;
	bool			operator !=(const fk_HVector &) const;
	fk_HVector &	operator =(const fk_HVector &);
	fk_HVector &	operator =(const fk_Vector &);
	fk_HVector &	operator *=(const fk_Matrix &);
	fk_HVector &	operator *=(const fk_UnitMatrix &);

	void		set(const fk_Vector &);
	void		set(const fk_Vector &, double);
	void		set(double, double, double = 0.0);
	void		set(double, double, double, double);
	void		setw(double);
	fk_Vector	getV(void) const;
	double		getw(void) const;
	void		ispos(void);
	void		isvec(void);
	void		init(void);
	void		Print(void) const;
	void		Print(std::string) const;

	friend double		operator *(const fk_HVector &, const fk_HVector &);
	friend fk_HVector	operator *(const fk_Matrix &, const fk_HVector &);
	friend fk_HVector	operator *(const fk_UnitMatrix &, const fk_HVector &);
};


double	fk_CalcCosine(fk_Vector, fk_Vector);

// 二項演算子の外部関数宣言
	
// 内積演算子
double			operator *(const fk_Vector &, const fk_Vector &);

// 和演算子
fk_Vector		operator +(const fk_Vector &, const fk_Vector &);

// 差演算子
fk_Vector		operator -(const fk_Vector &, const fk_Vector &);

// 実数倍演算子 
fk_Vector		operator *(const fk_Vector &, double);

// 実数倍演算子 
fk_Vector		operator *(double, const fk_Vector &);

// 実数商演算子 
fk_Vector		operator /(const fk_Vector &, double);

// 外積演算子 
fk_Vector		operator ^(const fk_Vector &, const fk_Vector &);

class fk_FVector {
 public:
	float x, y, z;

	fk_FVector(void);
	fk_FVector(const fk_FVector &);
	fk_FVector(const fk_Vector &);
	fk_FVector &	operator =(const fk_Vector &);
};

#endif /* !__FK_VECTOR_HEADER__ */
