<?php
 require_once 'PEAR/Command/Common.php'; class PEAR_Command_Mirror extends PEAR_Command_Common { var $commands = array( 'download-all' => array( 'summary' => 'Downloads each available package from the default channel', 'function' => 'doDownloadAll', 'shortcut' => 'da', 'options' => array( 'channel' => array( 'shortopt' => 'c', 'doc' => 'specify a channel other than the default channel', 'arg' => 'CHAN', ), ), 'doc' => '
Requests a list of available packages from the default channel ({config default_channel})
and downloads them to current working directory.  Note: only
packages within preferred_state ({config preferred_state}) will be downloaded' ), ); function PEAR_Command_Mirror(&$ui, &$config) { parent::PEAR_Command_Common($ui, $config); } function &factory($a) { $a = &PEAR_Command::factory($a, $this->config); return $a; } function doDownloadAll($command, $options, $params) { $savechannel = $this->config->get('default_channel'); $reg = &$this->config->getRegistry(); $channel = isset($options['channel']) ? $options['channel'] : $this->config->get('default_channel'); if (!$reg->channelExists($channel)) { $this->config->set('default_channel', $savechannel); return $this->raiseError('Channel "' . $channel . '" does not exist'); } $this->config->set('default_channel', $channel); $this->ui->outputData('Using Channel ' . $this->config->get('default_channel')); $chan = $reg->getChannel($channel); if (PEAR::isError($chan)) { return $this->raiseError($chan); } if ($chan->supportsREST($this->config->get('preferred_mirror')) && $base = $chan->getBaseURL('REST1.0', $this->config->get('preferred_mirror'))) { $rest = &$this->config->getREST('1.0', array()); $remoteInfo = array_flip($rest->listPackages($base, $channel)); } if (PEAR::isError($remoteInfo)) { return $remoteInfo; } $cmd = &$this->factory("download"); if (PEAR::isError($cmd)) { return $cmd; } $this->ui->outputData('Using Preferred State of ' . $this->config->get('preferred_state')); $this->ui->outputData('Gathering release information, please wait...'); PEAR::staticPushErrorHandling(PEAR_ERROR_RETURN); $err = $cmd->run('download', array('downloadonly' => true), array_keys($remoteInfo)); PEAR::staticPopErrorHandling(); $this->config->set('default_channel', $savechannel); if (PEAR::isError($err)) { $this->ui->outputData($err->getMessage()); } return true; } }