/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.validator.processor.internal;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.internal.ValidationRuleList;
import com.small_it_office.flatserve.validator.internal.util.AnnotationUtil;
import com.small_it_office.flatserve.validator.internal.util.ErrorUtil;
import com.small_it_office.flatserve.validator.processor.internal.ParameterValidationProcessor;
import com.small_it_office.flatserve.validator.rule.ItemName;
import com.small_it_office.flatserve.validator.type.internal.TypeValidation;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterValidationProcessorImpl<T>
implements ParameterValidationProcessor<T> {
    private MessageResource messageResource;
    private TypeValidation<T> typeValidation;
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public ParameterValidationProcessorImpl(MessageResource messageResource, TypeValidation<T> typeValidation) {
        this.messageResource = messageResource;
        this.typeValidation = typeValidation;
    }

    @Override
    public T process(RequestContext context, ValidationRuleList ruleList, String paramName, Annotation[] annotations) {
        String itemName;
        HttpServletRequest request = context.getHttpServletRequest();
        String valueString = request.getParameter(paramName);
        ItemName itemNameAnnotation = AnnotationUtil.findAnnotation(annotations, ItemName.class);
        String string = itemName = itemNameAnnotation == null ? null : itemNameAnnotation.value();
        if (itemName != null) {
            itemName = ErrorUtil.createMessage(this.messageResource, itemName, new Object[0]);
        }
        if (!this.typeValidation.isValidType(valueString, annotations)) {
            this.logger.debug("FSVLD-LOGD014", new Object[]{paramName, valueString});
            String message = this.typeValidation.getInvalidTypeMessage(this.messageResource, valueString, annotations);
            message = ErrorUtil.addItemNameMessage(this.messageResource, itemName, message);
            ErrorUtil.createValidationErrorObject(context, paramName, valueString, message);
            return null;
        }
        this.logger.debug("FSVLD-LOGD015", new Object[]{paramName, valueString});
        T value = this.typeValidation.validTypeValue(valueString, annotations);
        this.logger.debug("FSVLD-LOGD016", new Object[]{paramName, valueString});
        if (!ruleList.validateRules(context, paramName, valueString, value, itemName)) {
            this.logger.debug("FSVLD-LOGD017", new Object[]{paramName, valueString});
            return this.typeValidation.getNullValue();
        }
        return value;
    }
}

