/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.core;

import com.small_it_office.flatserve.core.config.ApplicationInitializer;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.config.InitializationException;
import com.small_it_office.flatserve.core.config.internal.DefaultApplicationInitializer;
import com.small_it_office.flatserve.core.process.internal.HttpServiceProcessor;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FlatServe
extends HttpServlet {
    private static final String PARAM_NAME_INIT_CLASS_NAME = "init-class-name";
    private HttpServiceProcessor processor;
    private Logger logger = LoggerFactory.getInstance().getLogger(((Object)((Object)this)).getClass());

    public void init() {
        Message.load("flatserve-messages");
        this.logger.debug("FS-LOGD001", new Object[0]);
        ApplicationInitializer initializer = this.createInitializer();
        Config config = this.createConfig(initializer);
        this.logger.debug("FS-LOGD002", config);
        if (!Locale.getDefault().equals(config.getLocale())) {
            Message.clear("flatserve-messages");
            Message.load("flatserve-messages", config.getLocale());
        }
        this.processor = new HttpServiceProcessor(config);
    }

    ApplicationInitializer createInitializer() {
        ApplicationInitializer initializer;
        Class<?> initClass;
        String initClassName = this.getServletConfig().getInitParameter(PARAM_NAME_INIT_CLASS_NAME);
        if (initClassName == null) {
            this.logger.debug("FS-LOGD003", new Object[0]);
            return new DefaultApplicationInitializer();
        }
        try {
            initClass = Class.forName(initClassName);
        }
        catch (ClassNotFoundException e) {
            throw new InitializationException(Message.get("FS-ERR002", initClassName), e);
        }
        if (!ApplicationInitializer.class.isAssignableFrom(initClass)) {
            throw new InitializationException(Message.get("FS-ERR003", initClassName));
        }
        try {
            initializer = (ApplicationInitializer)initClass.newInstance();
        }
        catch (Exception e) {
            throw new InitializationException(Message.get("FS-ERR004", initClassName), e);
        }
        return initializer;
    }

    private Config createConfig(ApplicationInitializer initializer) {
        Config config;
        String initializerClassName = initializer.getClass().getName();
        this.logger.info("FS-LOGI001", initializerClassName);
        try {
            config = initializer.init(this.getServletConfig());
        }
        catch (Throwable e) {
            throw new InitializationException(Message.get("FS-ERR005", initializer.getClass().getName()), e);
        }
        this.logger.info("FS-LOGI002", initializerClassName);
        if (config == null) {
            throw new InitializationException(Message.get("FS-ERR006", initializer.getClass().getName()));
        }
        return config;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.info("FS-LOGI003", "POST", request.getRequestURI());
        this.doProcess(request, response);
        this.logger.info("FS-LOGI004", "POST", request.getRequestURI());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.info("FS-LOGI003", "GET", request.getRequestURI());
        this.doProcess(request, response);
        this.logger.info("FS-LOGI004", "GET", request.getRequestURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcess(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestContext context = RequestContext.create(request, response, this.getServletConfig());
        try {
            this.processor.process(context);
        }
        finally {
            RequestContext.clear();
        }
    }
}

