/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.core.process.internal;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginLoader;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.internal.RequestParameterReader;
import com.small_it_office.flatserve.core.response.internal.ResponseSender;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.core.service.internal.HttpServiceFactory;
import com.small_it_office.flatserve.core.service.internal.HttpServiceResolver;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServiceProcessor {
    private static final int HTTP_STATUS_NOT_FOUND = 404;
    private RequestParameterReader requestReader;
    private ResponseSender responseSender;
    private HttpServiceFactory serviceFactory;
    private HttpServiceExecutor serviceExecutor;
    private Config config;
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public HttpServiceProcessor(Config config) {
        this.config = config;
        PluginLoader pluginLoader = new PluginLoader(config);
        this.requestReader = pluginLoader.load(RequestParameterReader.class);
        this.responseSender = pluginLoader.load(ResponseSender.class);
        this.serviceFactory = pluginLoader.load(HttpServiceFactory.class);
        this.serviceExecutor = pluginLoader.load(HttpServiceExecutor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RequestContext context) throws IOException {
        HttpServletRequest request = context.getHttpServletRequest();
        request.setCharacterEncoding(this.config.getRequestEncoding());
        HttpServiceResolver resolver = new HttpServiceResolver(this.config);
        resolver.resolveURI(request.getRequestURI(), request.getContextPath());
        Class<?> serviceClass = resolver.getServiceClass();
        Method method = resolver.getServiceMethod();
        if (method == null) {
            this.logger.info("FS-LOGI005", request.getRequestURI());
            HttpServletResponse response = context.getHttpServletResponse();
            response.setStatus(404);
            return;
        }
        if (resolver.isMethodSynchronized() && request.getSession(false) != null) {
            HttpSession httpSession = request.getSession(false);
            synchronized (httpSession) {
                this.doProcess(context, serviceClass, method);
            }
        } else {
            this.doProcess(context, serviceClass, method);
        }
    }

    private void doProcess(RequestContext context, Class<?> serviceClass, Method method) throws IOException {
        Object service;
        Object[] params = this.requestReader.process(context, serviceClass, method);
        Object responseObject = this.serviceExecutor.execute(context, method, params, service = this.serviceFactory.createHttpService(context, serviceClass, method));
        if (responseObject != null) {
            this.responseSender.process(context, responseObject);
        }
    }
}

