/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.core.request;

import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.Param;
import com.small_it_office.flatserve.core.request.ParameterMappingException;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Populator {
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());
    private static Populator instance = new Populator();

    protected Populator() {
    }

    public static Populator getInstance() {
        return instance;
    }

    public <T> T populate(Class<T> beanType) {
        HttpServletRequest request = RequestContext.get().getHttpServletRequest();
        T bean = this.createInstance(beanType);
        this.logger.debug("FS-LOGD021", bean.getClass().getName());
        List<Field> fields = this.searchAllFields(beanType);
        for (Field field : fields) {
            Param annotation = field.getAnnotation(Param.class);
            String requestParamName = annotation == null ? field.getName() : annotation.value();
            String[] paramValues = this.castMap(request.getParameterMap()).get(requestParamName);
            if (paramValues == null) {
                this.processNullParameter(bean, field, requestParamName);
                continue;
            }
            field.setAccessible(true);
            try {
                this.setValueToField(bean, field, requestParamName, paramValues);
            }
            catch (Exception e) {
                throw new UnexpectedException(e);
            }
        }
        this.logger.debug("FS-LOGD022", bean.getClass().getName());
        return bean;
    }

    private <T> T createInstance(Class<T> beanType) {
        T bean;
        try {
            bean = beanType.newInstance();
        }
        catch (Exception e) {
            throw new ParameterMappingException(Message.get("FS-ERR012", beanType.getName()), e);
        }
        return bean;
    }

    private List<Field> searchAllFields(Class<?> beanType) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> currentClass = beanType; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            Field[] fieldArray = currentClass.getDeclaredFields();
            fields.addAll(Arrays.asList(fieldArray));
        }
        return fields;
    }

    private Map<String, String[]> castMap(Map map) {
        return map;
    }

    protected void processNullParameter(Object bean, Field field, String requestParamName) {
        this.logger.debug("FS-LOGD023", field.getName(), requestParamName);
    }

    protected void setValueToField(Object bean, Field field, String requestParamName, String[] paramValues) throws IllegalAccessException {
        if (field.getType() == String.class) {
            field.set(bean, paramValues[0]);
            this.logger.debug("FS-LOGD024", field.getName(), requestParamName);
        } else if (field.getType() == String[].class) {
            field.set(bean, paramValues);
            this.logger.debug("FS-LOGD024", field.getName(), requestParamName);
        } else {
            this.logger.debug("FS-LOGD037", field.getName(), requestParamName);
        }
    }
}

