/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.core.response;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Response {
    private int statusCode;
    private Map<String, String> headers = new HashMap<String, String>();
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    protected abstract String getContentType();

    protected abstract void writeResponse(RequestContext var1) throws IOException;

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setHeader(String name, String value) {
        if (name != null) {
            name = name.toLowerCase();
        }
        this.headers.put(name, value);
    }

    public String getHeader(String name) {
        if (name != null) {
            name = name.toLowerCase();
        }
        return this.headers.get(name);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void sendResponse(RequestContext context) throws IOException {
        this.logger.debug("FS-LOGD030", this.getClass().getSimpleName());
        HttpServletResponse response = context.getHttpServletResponse();
        Set<String> names = this.headers.keySet();
        if (this.statusCode != 0) {
            this.logger.debug("FS-LOGD041", this.statusCode);
            response.setStatus(this.statusCode);
        }
        for (String name : names) {
            String value = this.headers.get(name);
            this.logger.debug("FS-LOGD031", name, value);
            response.setHeader(name, value);
        }
        String contentType = this.getContentType();
        this.logger.debug("FS-LOGD032", contentType);
        response.setContentType(contentType);
        this.writeResponse(context);
    }
}

