/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.core.service.internal;

import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.service.HttpServiceException;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class HttpServiceExecutorImpl
implements HttpServiceExecutor {
    private static final int PLUGIN_PRIORITY = 1024;
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public Object execute(RequestContext context, Method method, Object[] params, Object serivce) {
        Object responseObject;
        this.logger.info("FS-LOGI006", serivce.getClass().getName(), method.getName());
        try {
            responseObject = method.invoke(serivce, params);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new HttpServiceException(Message.get("FS-ERR009", new Object[0]), e.getTargetException());
        }
        catch (Throwable e) {
            throw new UnexpectedException(e);
        }
        this.logger.info("FS-LOGI007", serivce.getClass().getName(), method.getName());
        return responseObject;
    }

    public boolean nest() {
        return false;
    }

    public void setNestedObject(PluginPart o) {
    }

    public void init(Config config) {
    }

    public int priority() {
        return 1024;
    }
}

