/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.shared.meslog.message;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Message {
    private static Map<String, ResourceBundle> resourceBundleMap = new HashMap<String, ResourceBundle>();

    private Message() {
    }

    public static synchronized void load(String bundleName) {
        if (resourceBundleMap.containsKey(bundleName)) {
            return;
        }
        ResourceBundle messages = null;
        try {
            messages = ResourceBundle.getBundle(bundleName);
        }
        catch (Throwable e) {
            Message.warnLoadFailed(bundleName, e);
            return;
        }
        resourceBundleMap.put(bundleName, messages);
    }

    public static synchronized void load(String bundleName, Locale locale) {
        if (resourceBundleMap.containsKey(bundleName)) {
            return;
        }
        ResourceBundle messages = null;
        try {
            messages = ResourceBundle.getBundle(bundleName, locale);
        }
        catch (Throwable e) {
            Message.warnLoadFailed(bundleName, e);
            return;
        }
        resourceBundleMap.put(bundleName, messages);
    }

    private static void warnLoadFailed(String bundleName, Throwable e) {
        String errorMessage = "WARNING by Shared-MessageAndLog:failed to load message resoucebundle '" + bundleName + "'for locale " + Locale.getDefault();
        System.err.println(errorMessage);
        e.printStackTrace();
    }

    public static String get(String code, Object ... params) {
        Collection<ResourceBundle> bundles = resourceBundleMap.values();
        String bundle = null;
        for (ResourceBundle messages : bundles) {
            try {
                bundle = messages.getString(code);
                break;
            }
            catch (MissingResourceException e) {
            }
        }
        if (bundle == null) {
            bundle = code + "(message not found)";
        }
        String message = MessageFormat.format(bundle, params);
        return message;
    }

    public static synchronized void clear() {
        resourceBundleMap.clear();
    }

    public static synchronized void clear(String bundleName) {
        resourceBundleMap.remove(bundleName);
    }
}

