/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.purehtml.internal.document;

import com.small_it_office.flatserve.purehtml.internal.document.ATagHrefValueModifier;
import com.small_it_office.flatserve.purehtml.internal.document.HtmlTagValueModifier;
import com.small_it_office.flatserve.purehtml.internal.document.ImgTagSrcValueModifier;
import com.small_it_office.flatserve.purehtml.internal.document.InputTagByIdValueModifier;
import com.small_it_office.flatserve.purehtml.internal.document.InputTagByNameValueModifier;
import com.small_it_office.flatserve.purehtml.internal.document.ListTagValueModifier;
import com.small_it_office.flatserve.purehtml.internal.document.NullTagValueModifier;
import com.small_it_office.flatserve.purehtml.internal.document.OptionTagValueModifier;
import com.small_it_office.flatserve.purehtml.internal.document.SelectTagValueModifier;
import com.small_it_office.flatserve.purehtml.internal.document.TableTagValueModifier;
import com.small_it_office.flatserve.purehtml.internal.document.TagTextValueModifier;
import com.small_it_office.flatserve.purehtml.internal.document.TextAreaTagValueModifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlDocumentProcessor {
    private Set<HtmlTagValueModifier> modifiersByName = new HashSet<HtmlTagValueModifier>();
    private Set<HtmlTagValueModifier> modifiersById = new HashSet<HtmlTagValueModifier>();
    private HtmlTagValueModifier nullModifier = new NullTagValueModifier();

    public HtmlDocumentProcessor() {
        this.modifiersByName.add(new InputTagByNameValueModifier());
        this.modifiersByName.add(new TextAreaTagValueModifier());
        this.modifiersByName.add(new SelectTagValueModifier());
        this.modifiersById.add(new TagTextValueModifier());
        this.modifiersById.add(new ListTagValueModifier());
        this.modifiersById.add(new ATagHrefValueModifier());
        this.modifiersById.add(new ImgTagSrcValueModifier());
        this.modifiersById.add(new TableTagValueModifier());
        this.modifiersById.add(new InputTagByIdValueModifier());
        this.modifiersById.add(new OptionTagValueModifier());
        this.modifiersById.add(new SelectTagValueModifier());
    }

    public String process(Source source, Map<String, Object> responseValues) {
        Set<Map.Entry<String, Object>> entries = responseValues.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            boolean modified;
            Object responseValue = responseValues.get(entry.getKey());
            OutputDocument outputDocument = new OutputDocument(source);
            Element element = source.getElementById(entry.getKey());
            if (element == null) {
                String elementName;
                List elementsByName = source.getAllElements("name", Pattern.compile(entry.getKey()));
                if (elementsByName.size() <= 0 || !(modified = this.getModifier(elementName = ((Element)elementsByName.get(0)).getName(), this.modifiersByName).modifyDocument(outputDocument, elementsByName, responseValue))) continue;
                source = new Source((CharSequence)outputDocument.toString());
                continue;
            }
            String elementName = element.getName();
            ArrayList<Element> elementList = new ArrayList<Element>();
            elementList.add(element);
            modified = this.getModifier(elementName, this.modifiersById).modifyDocument(outputDocument, elementList, responseValue);
            if (!modified) continue;
            source = new Source((CharSequence)outputDocument.toString());
        }
        return source.toString();
    }

    private HtmlTagValueModifier getModifier(String elementName, Set<HtmlTagValueModifier> modifiers) {
        for (HtmlTagValueModifier modifier : modifiers) {
            if (!modifier.responsible(elementName)) continue;
            return modifier;
        }
        return this.nullModifier;
    }
}

