/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.transition.internal;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.internal.RequestParameterReader;
import com.small_it_office.flatserve.transition.IllegalTokenException;
import com.small_it_office.flatserve.transition.Token;
import com.small_it_office.flatserve.transition.internal.TransitionChecker;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitionCheckRequestParameterReader
implements RequestParameterReader {
    private static final int PLUGIN_PRIORITY = 64;
    private TransitionChecker checker = new TransitionChecker();
    private RequestParameterReader requestReader;
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public Object[] process(RequestContext context, Class<?> serviceClass, Method method) {
        if (this.checker.check(context, serviceClass, method)) {
            context.setAttribute("transition.checkresult", (Object)"true");
            this.saveToken(context.getHttpServletRequest(), method);
            this.logger.debug("FSTRC-LOGD004", new Object[]{this.requestReader.getClass().getName()});
            Object[] result = this.requestReader.process(context, serviceClass, method);
            return result;
        }
        context.setAttribute("transition.checkresult", (Object)"false");
        return null;
    }

    private void saveToken(HttpServletRequest request, Method method) {
        Token tokenAnnotation = method.getAnnotation(Token.class);
        if (tokenAnnotation != null) {
            String token = tokenAnnotation.value();
            if ("".equals(token)) {
                throw new IllegalTokenException(Message.get((String)"FSTRC-ERR003", (Object[])new Object[]{method.getDeclaringClass().getName(), method.getName()}));
            }
            request.getSession().setAttribute("com.small_it_office.flatserve.transition.token", (Object)token);
            this.logger.debug("FSTRC-LOGD005", new Object[]{token});
        }
    }

    public boolean nest() {
        return true;
    }

    public void init(Config config) {
    }

    public void setNestedObject(PluginPart o) {
        this.requestReader = (RequestParameterReader)o;
    }

    public int priority() {
        return 64;
    }
}

