/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.validator.rule.internal;

import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.internal.util.ErrorUtil;
import com.small_it_office.flatserve.validator.internal.util.TypeConvertUtil;
import com.small_it_office.flatserve.validator.rule.DecimalMax;
import com.small_it_office.flatserve.validator.rule.ValidationRule;
import com.small_it_office.flatserve.validator.rule.ValidationRuleException;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;

public class DecimalMaxRule
implements ValidationRule {
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public String getMessage(MessageResource messageResource, String valueString, Annotation annotation) {
        String max = ((DecimalMax)annotation).value();
        boolean allowEquiv = ((DecimalMax)annotation).allowEquiv();
        String specified = ((DecimalMax)annotation).message();
        if ("".equals(specified)) {
            specified = allowEquiv ? "{message.error.decimal_max.allow_equiv}" : "{message.error.decimal_max.not_allow_equiv}";
        }
        return ErrorUtil.createMessage(messageResource, specified, valueString, max);
    }

    public boolean isValid(Object value, String valueString, Annotation annotation) {
        BigDecimal max;
        if (value == null) {
            this.logger.debug("FSVLD-LOGD018", new Object[]{this.ruleName(annotation)});
            return true;
        }
        BigDecimal bValue = TypeConvertUtil.bigDecimalValueOf(value);
        if (bValue == null) {
            this.logger.debug("FSVLD-LOGD019", new Object[]{valueString, this.ruleName(annotation)});
            return false;
        }
        String strMax = ((DecimalMax)annotation).value();
        boolean allowEquiv = ((DecimalMax)annotation).allowEquiv();
        try {
            max = new BigDecimal(strMax);
        }
        catch (NumberFormatException e) {
            throw new ValidationRuleException(Message.get((String)"FSVLD-ERR006", (Object[])new Object[]{this.ruleName(annotation), strMax}), e);
        }
        return bValue.compareTo(max) == -1 || allowEquiv && bValue.compareTo(max) == 0;
    }

    private String ruleName(Annotation annotation) {
        return annotation.annotationType().getSimpleName();
    }
}

