/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.validator.rule.internal;

import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.internal.util.ErrorUtil;
import com.small_it_office.flatserve.validator.rule.Length;
import com.small_it_office.flatserve.validator.rule.ValidationRule;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import java.lang.annotation.Annotation;

public class LengthRule
implements ValidationRule {
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public String getMessage(MessageResource messageResource, String valueString, Annotation annotation) {
        Length lengthAnnotation = (Length)annotation;
        String specified = lengthAnnotation.message();
        int min = lengthAnnotation.min();
        int max = lengthAnnotation.max();
        if (min <= 0) {
            specified = "{message.error.length.max}";
        } else if (max == Integer.MAX_VALUE) {
            specified = "{message.error.length.min}";
        }
        return ErrorUtil.createMessage(messageResource, specified, valueString, min, max);
    }

    public boolean isValid(Object value, String valueString, Annotation annotation) {
        if (valueString == null) {
            this.logger.debug("FSVLD-LOGD018", new Object[]{annotation.annotationType().getSimpleName()});
            return true;
        }
        Length lengthAnnotation = (Length)annotation;
        int min = lengthAnnotation.min();
        int max = lengthAnnotation.max();
        int length = valueString.length();
        return length >= min && length <= max;
    }
}

