/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.validator.rule.internal;

import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.internal.util.ErrorUtil;
import com.small_it_office.flatserve.validator.internal.util.TypeConvertUtil;
import com.small_it_office.flatserve.validator.rule.Max;
import com.small_it_office.flatserve.validator.rule.ValidationRule;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;

public class MaxRule
implements ValidationRule {
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public String getMessage(MessageResource messageResource, String valueString, Annotation annotation) {
        long max = ((Max)annotation).value();
        boolean allowEquiv = ((Max)annotation).allowEquiv();
        String specified = ((Max)annotation).message();
        if ("".equals(specified)) {
            specified = allowEquiv ? "{message.error.max.allow_equiv}" : "{message.error.max.not_allow_equiv}";
        }
        return ErrorUtil.createMessage(messageResource, specified, valueString, max);
    }

    public boolean isValid(Object value, String valueString, Annotation annotation) {
        if (value == null) {
            this.logger.debug("FSVLD-LOGD018", new Object[]{this.ruleName(annotation)});
            return true;
        }
        BigDecimal bValue = TypeConvertUtil.bigDecimalValueOf(value);
        if (bValue == null) {
            this.logger.debug("FSVLD-LOGD019", new Object[]{valueString, this.ruleName(annotation)});
            return false;
        }
        BigDecimal bMax = BigDecimal.valueOf(((Max)annotation).value());
        boolean allowEquiv = ((Max)annotation).allowEquiv();
        return bValue.compareTo(bMax) == -1 || allowEquiv && bValue.compareTo(bMax) == 0;
    }

    private String ruleName(Annotation annotation) {
        return annotation.annotationType().getSimpleName();
    }
}

